/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.central.dao;

import java.io.Serializable;
import java.util.Map;
import net.solarnetwork.dao.Entity;

public interface BulkLoadingDao<T extends Entity<PK>, PK extends Serializable> {
    public LoadingContext<T, PK> createBulkLoadingContext(LoadingOptions var1, LoadingExceptionHandler<T, PK> var2);

    public static interface LoadingContext<T extends Entity<PK>, PK extends Serializable>
    extends AutoCloseable {
        public LoadingOptions getOptions();

        public void load(T var1);

        public long getLoadedCount();

        public long getCommittedCount();

        public T getLastLoadedEntity();

        public void createCheckpoint();

        public void commit();

        public void rollback();

        @Override
        public void close();
    }

    public static interface LoadingExceptionHandler<T extends Entity<PK>, PK extends Serializable> {
        public void handleLoadingException(Throwable var1, LoadingContext<T, PK> var2);
    }

    public static interface LoadingOptions {
        public String getName();

        public Integer getBatchSize();

        public LoadingTransactionMode getTransactionMode();

        public Map<String, ?> getParameters();
    }

    public static enum LoadingTransactionMode {
        SingleTransaction,
        TransactionCheckpoints,
        BatchTransactions,
        NoTransaction;

    }
}

