/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.central.dao;

import java.io.Serializable;
import java.time.Instant;
import net.solarnetwork.central.dao.UserRelatedEntity;
import net.solarnetwork.central.domain.BasePK;
import net.solarnetwork.central.domain.CompositeKey;
import net.solarnetwork.dao.BasicEntity;
import net.solarnetwork.domain.CopyingIdentity;
import net.solarnetwork.domain.Differentiable;
import net.solarnetwork.util.ObjectUtils;

public abstract class BaseUserModifiableEntity<C extends BaseUserModifiableEntity<C, K>, K extends CompositeKey & Comparable<K>>
extends BasicEntity<K>
implements UserRelatedEntity<K>,
CopyingIdentity<K, C>,
Differentiable<C>,
Serializable,
Cloneable {
    private static final long serialVersionUID = -8201311252309117005L;
    private Instant modified;
    private boolean enabled;

    public BaseUserModifiableEntity(K id, Instant created) {
        super((Comparable)((Object)((CompositeKey)ObjectUtils.requireNonNullArgument(id, (String)"id"))), (Instant)ObjectUtils.requireNonNullArgument((Object)created, (String)"created"));
    }

    public C clone() {
        return (C)((BaseUserModifiableEntity)super.clone());
    }

    public void copyTo(C entity) {
        ((BaseUserModifiableEntity)entity).setModified(this.modified);
        ((BaseUserModifiableEntity)entity).setEnabled(this.enabled);
    }

    public boolean isSameAs(C other) {
        return this.enabled == ((BaseUserModifiableEntity)other).isEnabled();
    }

    public boolean differsFrom(C other) {
        return !this.isSameAs(other);
    }

    @Override
    public Long getUserId() {
        CompositeKey pk = (CompositeKey)((Object)this.getId());
        return pk != null ? (Long)pk.keyComponent(0) : null;
    }

    public String ident() {
        CompositeKey id = (CompositeKey)((Object)this.getId());
        StringBuilder buf = new StringBuilder(64);
        if (id instanceof BasePK) {
            BasePK pk = (BasePK)((Object)id);
            buf.append(pk.getId());
        } else if (id != null) {
            buf.append(id.toString());
        }
        Instant mod = this.getModified();
        if (mod != null) {
            buf.append('.');
            buf.append(mod.getEpochSecond());
        }
        return buf.toString();
    }

    public Instant getModified() {
        return this.modified;
    }

    public void setModified(Instant modified) {
        this.modified = modified;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }
}

