/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.central.dao;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.io.Serializable;
import java.time.Instant;
import java.util.Objects;
import net.solarnetwork.central.domain.AuditNodeServiceValue;
import net.solarnetwork.dao.BasicIdentity;
import net.solarnetwork.domain.Differentiable;
import net.solarnetwork.domain.datum.Aggregation;
import net.solarnetwork.domain.datum.DatumId;

@JsonPropertyOrder(value={"ts", "nodeId", "service", "aggregation", "count"})
@JsonIgnoreProperties(value={"id"})
public class AuditNodeServiceEntity
extends BasicIdentity<DatumId>
implements AuditNodeServiceValue,
Cloneable,
Serializable,
Differentiable<AuditNodeServiceValue> {
    private static final long serialVersionUID = 8906783581107973754L;
    private final Aggregation aggregation;
    private final long count;

    public static AuditNodeServiceEntity hourlyAuditNodeService(Long nodeId, String service, Instant timestamp, long count) {
        return new AuditNodeServiceEntity(DatumId.nodeId((Long)nodeId, (String)service, (Instant)timestamp), Aggregation.Hour, count);
    }

    public static AuditNodeServiceEntity dailyAuditNodeService(Long nodeId, String service, Instant timestamp, long count) {
        return new AuditNodeServiceEntity(DatumId.nodeId((Long)nodeId, (String)service, (Instant)timestamp), Aggregation.Day, count);
    }

    public static AuditNodeServiceEntity monthlyAuditNodeService(Long nodeId, String service, Instant timestamp, long count) {
        return new AuditNodeServiceEntity(DatumId.nodeId((Long)nodeId, (String)service, (Instant)timestamp), Aggregation.Month, count);
    }

    public static AuditNodeServiceEntity accumulativeAuditNodeService(Long nodeId, String service, Instant timestamp, long count) {
        return new AuditNodeServiceEntity(DatumId.nodeId((Long)nodeId, (String)service, (Instant)timestamp), Aggregation.RunningTotal, count);
    }

    public AuditNodeServiceEntity(DatumId id, Aggregation aggregation, long count) {
        super((Comparable)id);
        this.aggregation = aggregation == null ? Aggregation.None : aggregation;
        this.count = count;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("AuditNodeServiceEntity{aggregation=");
        builder.append(this.aggregation);
        builder.append(", nodeId=");
        builder.append(this.getNodeId());
        builder.append(", service=");
        builder.append(this.getService());
        builder.append(", timestamp=");
        builder.append(this.getTimestamp());
        builder.append(", count=");
        builder.append(this.count);
        builder.append("}");
        return builder.toString();
    }

    public boolean isSameAs(AuditNodeServiceValue other) {
        if (other == null) {
            return false;
        }
        return Objects.equals(this.getId(), other.getId()) && Objects.equals(this.aggregation, other.getAggregation()) && Objects.equals(this.count, other.getCount());
    }

    public boolean differsFrom(AuditNodeServiceValue other) {
        return !this.isSameAs(other);
    }

    @Override
    @JsonProperty(value="ts")
    public Instant getTimestamp() {
        return AuditNodeServiceValue.super.getTimestamp();
    }

    @Override
    public Aggregation getAggregation() {
        return this.aggregation;
    }

    @Override
    public long getCount() {
        return this.count;
    }
}

