/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.central.common.mail.javamail;

import jakarta.activation.FileTypeMap;
import jakarta.mail.Message;
import jakarta.mail.internet.MimeMessage;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import java.util.function.Consumer;
import net.solarnetwork.util.ClassUtils;
import org.springframework.mail.MailException;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.mail.javamail.MimeMessagePreparator;

public class ManagedJavaMailSender
implements JavaMailSender {
    private JavaMailSenderImpl delegate = new JavaMailSenderImpl();

    public synchronized void configurationChanged(Map<String, Object> properties) {
        Map settings = ClassUtils.getSimpleBeanProperties((Object)this.delegate, null);
        Properties props = this.delegate.getJavaMailProperties();
        JavaMailSenderImpl updated = new JavaMailSenderImpl();
        ClassUtils.setBeanProperties((Object)updated, (Map)settings, (boolean)true);
        updated.setJavaMailProperties(props);
        this.delegate = updated;
    }

    public ManagedJavaMailSender getMail() {
        return this;
    }

    public Properties getJavaMailProperties() {
        return this.delegate.getJavaMailProperties();
    }

    public void setJavaMailProperties(Properties javaMailProperties) {
        this.delegate.setJavaMailProperties(javaMailProperties);
    }

    public void setProtocol(String protocol) {
        this.delegate.setProtocol(protocol);
    }

    public void setHost(String host) {
        this.delegate.setHost(host);
    }

    public void setPort(int port) {
        this.delegate.setPort(port);
    }

    public void setUsername(String username) {
        this.delegate.setUsername(username);
    }

    public void setPassword(String password) {
        this.delegate.setPassword(password);
    }

    public void setDefaultEncoding(String defaultEncoding) {
        this.delegate.setDefaultEncoding(defaultEncoding);
    }

    public void setDefaultFileTypeMap(FileTypeMap defaultFileTypeMap) {
        this.delegate.setDefaultFileTypeMap(defaultFileTypeMap);
    }

    public void send(SimpleMailMessage simpleMessage) throws MailException {
        this.delegate.send(simpleMessage);
    }

    public void send(SimpleMailMessage ... simpleMessages) throws MailException {
        this.delegate.send(simpleMessages);
    }

    public MimeMessage createMimeMessage() {
        return this.delegate.createMimeMessage();
    }

    public MimeMessage createMimeMessage(InputStream contentStream) throws MailException {
        return this.delegate.createMimeMessage(contentStream);
    }

    private void doWithSender(Consumer<JavaMailSender> handler) {
        ClassLoader oldCCL = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(Message.class.getClassLoader());
        try {
            handler.accept((JavaMailSender)this.delegate);
        }
        finally {
            if (oldCCL != null) {
                Thread.currentThread().setContextClassLoader(oldCCL);
            }
        }
    }

    public void send(final MimeMessage mimeMessage) throws MailException {
        this.doWithSender(new Consumer<JavaMailSender>(){

            @Override
            public void accept(JavaMailSender sender) {
                sender.send(mimeMessage);
            }
        });
    }

    public void send(final MimeMessage ... mimeMessages) throws MailException {
        this.doWithSender(new Consumer<JavaMailSender>(){

            @Override
            public void accept(JavaMailSender sender) {
                sender.send(mimeMessages);
            }
        });
    }

    public void send(final MimeMessagePreparator mimeMessagePreparator) throws MailException {
        this.doWithSender(new Consumer<JavaMailSender>(){

            @Override
            public void accept(JavaMailSender sender) {
                sender.send(mimeMessagePreparator);
            }
        });
    }

    public void send(final MimeMessagePreparator ... mimeMessagePreparators) throws MailException {
        this.doWithSender(new Consumer<JavaMailSender>(){

            @Override
            public void accept(JavaMailSender sender) {
                sender.send(mimeMessagePreparators);
            }
        });
    }
}

