/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.central.common.job;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import net.solarnetwork.central.common.job.TieredStaleRecordProcessor;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ConnectionCallback;
import org.springframework.jdbc.core.JdbcOperations;

public class TieredStoredProcedureStaleRecordProcessor
extends TieredStaleRecordProcessor {
    private static final Pattern CALL_RETURN_COUNT = Pattern.compile("\\?\\s=\\s*call\\s+", 2);

    public TieredStoredProcedureStaleRecordProcessor(JdbcOperations jdbcOps, String taskDescription) {
        super(jdbcOps, taskDescription);
    }

    @Override
    protected final int execute(final AtomicInteger remainingCount) {
        final String tierProcessType = this.getTierProcessType();
        final Integer tierProcessMax = this.getTierProcessMax();
        return (Integer)this.getJdbcOps().execute((ConnectionCallback)new ConnectionCallback<Integer>(){

            public Integer doInConnection(Connection con) throws SQLException, DataAccessException {
                String sql = TieredStoredProcedureStaleRecordProcessor.this.getJdbcCall();
                int paramCount = (int)sql.chars().filter(ch -> ch == 63).count();
                try (CallableStatement call = con.prepareCall(sql);){
                    int idx = 0;
                    if (CALL_RETURN_COUNT.matcher(sql).find() && idx < paramCount) {
                        call.registerOutParameter(++idx, 4);
                    }
                    if (idx < paramCount) {
                        call.setString(++idx, tierProcessType);
                    }
                    if (tierProcessMax != null && idx < paramCount) {
                        call.setInt(++idx, (int)tierProcessMax);
                    }
                    con.setAutoCommit(true);
                    int resultCount = 0;
                    int processedCount = 0;
                    do {
                        if (call.execute()) {
                            try (ResultSet rs = call.getResultSet();){
                                if (rs.next()) {
                                    TieredStoredProcedureStaleRecordProcessor.this.processResultRow(rs);
                                    resultCount = 1;
                                }
                                resultCount = 0;
                            }
                        } else {
                            resultCount = call.getInt(1);
                        }
                        processedCount += resultCount;
                        remainingCount.addAndGet(-resultCount);
                    } while (resultCount > 0 && remainingCount.get() > 0);
                    Integer n = processedCount;
                    return n;
                }
            }
        });
    }

    protected void processResultRow(ResultSet rs) throws SQLException {
        if (this.log.isDebugEnabled()) {
            ResultSetMetaData meta = rs.getMetaData();
            int colCount = meta.getColumnCount();
            LinkedHashMap<String, Object> row = new LinkedHashMap<String, Object>(colCount);
            for (int i = 1; i <= colCount; ++i) {
                row.put(meta.getColumnName(i), rs.getObject(i));
            }
            this.log.debug("Processed stale row: {}", row);
        }
    }
}

