/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.central.common.job;

import java.util.concurrent.atomic.AtomicInteger;
import net.solarnetwork.central.common.job.StaleRecordProcessor;
import net.solarnetwork.util.ObjectUtils;
import org.springframework.dao.CannotAcquireLockException;
import org.springframework.jdbc.core.JdbcOperations;

public abstract class TieredStaleRecordProcessor
extends StaleRecordProcessor {
    private final String taskDescription;
    private String tierProcessType = "h";
    private Integer tierProcessMax;

    public TieredStaleRecordProcessor(JdbcOperations jdbcOps, String taskDescription) {
        super(jdbcOps);
        this.taskDescription = (String)ObjectUtils.requireNonNullArgument((Object)taskDescription, (String)"taskDescription");
        this.setMaximumIterations(1);
        this.setParallelism(1);
    }

    protected abstract int execute(AtomicInteger var1);

    @Override
    protected int executeJobTask(AtomicInteger remainingIterataions) throws Exception {
        try {
            return this.execute(remainingIterataions);
        }
        catch (CannotAcquireLockException e) {
            this.log.warn("Failure acquiring DB lock while processing {} for tier '{}' with call {}", new Object[]{this.taskDescription, this.tierProcessType, this.getJdbcCall(), e});
            return 0;
        }
    }

    @Override
    public void run() {
        this.executeParallelJob(String.format("%s tier '%s'", this.taskDescription, this.tierProcessType));
    }

    public String getTierProcessType() {
        return this.tierProcessType;
    }

    public void setTierProcessType(String tierProcessType) {
        this.tierProcessType = tierProcessType;
    }

    public Integer getTierProcessMax() {
        return this.tierProcessMax;
    }

    public void setTierProcessMax(Integer tierProcessMax) {
        this.tierProcessMax = tierProcessMax;
    }
}

