/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.central.common.job;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import net.solarnetwork.central.scheduler.JobSupport;
import net.solarnetwork.util.ObjectUtils;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.CallableStatementCallback;
import org.springframework.jdbc.core.CallableStatementCreator;
import org.springframework.jdbc.core.JdbcOperations;

public class JdbcCallJob
extends JobSupport {
    private final JdbcOperations jdbcOps;
    private String jdbcCall;

    public JdbcCallJob(JdbcOperations jdbcOps) {
        this.jdbcOps = (JdbcOperations)ObjectUtils.requireNonNullArgument((Object)jdbcOps, (String)"jdbcOps");
        this.setGroupId("Datum");
        this.setMaximumWaitMs(1800000L);
    }

    @Override
    public void run() {
        this.log.info("Job {} executing JDBC call {}...", (Object)this.getId(), (Object)this.getJdbcCall());
        Long result = (Long)this.jdbcOps.execute(new CallableStatementCreator(){

            public CallableStatement createCallableStatement(Connection con) throws SQLException {
                CallableStatement call = con.prepareCall(JdbcCallJob.this.getJdbcCall());
                call.registerOutParameter(1, -5);
                return call;
            }
        }, (CallableStatementCallback)new CallableStatementCallback<Long>(this){

            public Long doInCallableStatement(CallableStatement cs) throws SQLException, DataAccessException {
                cs.execute();
                return cs.getLong(1);
            }
        });
        this.log.info("Job {} JDBC call result: {}", (Object)this.getId(), (Object)result);
    }

    public JdbcOperations getJdbcOps() {
        return this.jdbcOps;
    }

    public String getJdbcCall() {
        return this.jdbcCall;
    }

    public void setJdbcCall(String jdbcCall) {
        this.jdbcCall = jdbcCall;
    }
}

