/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.central.common.dao.jdbc.sql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import net.solarnetwork.central.domain.LocationRequest;
import net.solarnetwork.util.ObjectUtils;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.SqlProvider;

public class UpdateLocationRequest
implements PreparedStatementCreator,
SqlProvider {
    private final LocationRequest request;
    private final Long id;

    public UpdateLocationRequest(LocationRequest request) {
        this.request = (LocationRequest)((Object)ObjectUtils.requireNonNullArgument((Object)((Object)request), (String)"request"));
        this.id = (Long)ObjectUtils.requireNonNullArgument((Object)((Long)request.getId()), (String)"request.id");
    }

    public String getSql() {
        StringBuilder buf = new StringBuilder();
        buf.append("UPDATE solarnet.sn_loc_req SET modified = CURRENT_TIMESTAMP");
        if (this.request.getLocationId() != null) {
            buf.append("\n\t, loc_id = ?");
        }
        if (this.request.getStatus() != null) {
            buf.append("\n\t, status = ?");
        }
        if (this.request.getMessage() != null) {
            buf.append("\n\t, message = ?");
        }
        if (this.request.getJsonData() != null) {
            buf.append("\n\t, jdata = ?::jsonb");
        }
        buf.append("\nWHERE id = ?");
        return buf.toString();
    }

    public PreparedStatement createPreparedStatement(Connection con) throws SQLException {
        PreparedStatement stmt = con.prepareStatement(this.getSql(), 1);
        int p = 0;
        if (this.request.getLocationId() != null) {
            stmt.setObject(++p, this.request.getLocationId());
        }
        if (this.request.getStatus() != null) {
            stmt.setString(++p, String.valueOf((char)this.request.getStatus().getCode()));
        }
        if (this.request.getMessage() != null) {
            stmt.setString(++p, this.request.getMessage());
        }
        if (this.request.getJsonData() != null) {
            stmt.setString(++p, this.request.getJsonData());
        }
        stmt.setObject(++p, this.id);
        return stmt;
    }
}

