/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.central.common.dao.jdbc.sql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import net.solarnetwork.central.domain.CompositeKey;
import net.solarnetwork.util.ObjectUtils;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.SqlProvider;

public class UpdateEnabledIdFilter
implements PreparedStatementCreator,
SqlProvider {
    private String tableName;
    private String[] idColumnNames;
    private CompositeKey filter;
    private boolean enabled;

    public UpdateEnabledIdFilter(String tableName, String[] idColumnNames, CompositeKey filter, boolean enabled) {
        this.tableName = (String)ObjectUtils.requireNonNullArgument((Object)tableName, (String)"tableName");
        this.idColumnNames = (String[])ObjectUtils.requireNonEmptyArgument((Object[])idColumnNames, (String)"idColumnNames");
        this.filter = (CompositeKey)ObjectUtils.requireNonNullArgument((Object)filter, (String)"filter");
        this.enabled = enabled;
    }

    public String getSql() {
        StringBuilder buf = new StringBuilder();
        this.sqlCore(buf);
        this.sqlWhere(buf);
        return buf.toString();
    }

    private void sqlCore(StringBuilder buf) {
        buf.append("UPDATE %s\nSET enabled = ?, modified = CURRENT_TIMESTAMP\n".formatted(this.tableName));
    }

    private void sqlWhere(StringBuilder buf) {
        StringBuilder where = null;
        int componentCount = this.filter.keyComponentLength();
        for (int i = 0; i < componentCount && i < this.idColumnNames.length; ++i) {
            if (!this.filter.keyComponentIsAssigned(i)) continue;
            if (where == null) {
                where = new StringBuilder();
            }
            where.append("\tAND ").append(this.idColumnNames[i]).append(" = ?\n");
        }
        if (where != null) {
            buf.append("WHERE").append(where.substring(4));
        }
    }

    public PreparedStatement createPreparedStatement(Connection con) throws SQLException {
        PreparedStatement stmt = con.prepareStatement(this.getSql());
        int p = 0;
        stmt.setBoolean(++p, this.enabled);
        p = this.prepareWhere(con, stmt, p);
        return stmt;
    }

    private int prepareWhere(Connection con, PreparedStatement stmt, int p) throws SQLException {
        int componentCount = this.filter.keyComponentLength();
        for (int i = 0; i < componentCount && i < this.idColumnNames.length; ++i) {
            if (!this.filter.keyComponentIsAssigned(i)) continue;
            stmt.setObject(++p, this.filter.keyComponent(i));
        }
        return p;
    }
}

