/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.central.common.dao.jdbc.sql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import net.solarnetwork.central.common.dao.UserEventFilter;
import net.solarnetwork.central.common.dao.jdbc.CountPreparedStatementCreatorProvider;
import net.solarnetwork.central.common.dao.jdbc.sql.CommonSqlUtils;
import net.solarnetwork.central.support.SearchFilterUtils;
import net.solarnetwork.util.ObjectUtils;
import net.solarnetwork.util.SearchFilter;
import net.solarnetwork.util.TimeBasedV7UuidGenerator;
import net.solarnetwork.util.UuidTimestampDecoder;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.SqlProvider;

public class SelectUserEvent
implements PreparedStatementCreator,
SqlProvider,
CountPreparedStatementCreatorProvider {
    public static final int DEFAULT_FETCH_SIZE = 1000;
    private final UuidTimestampDecoder uuidTimestampDecoder;
    private final UserEventFilter filter;
    private final int fetchSize;
    private final SearchFilter searchFilter;

    public SelectUserEvent(UserEventFilter filter) {
        this((UuidTimestampDecoder)TimeBasedV7UuidGenerator.INSTANCE_MICROS, filter, 1000);
    }

    public SelectUserEvent(UuidTimestampDecoder uuidTimestampDecoder, UserEventFilter filter, int fetchSize) {
        this.uuidTimestampDecoder = (UuidTimestampDecoder)ObjectUtils.requireNonNullArgument((Object)uuidTimestampDecoder, (String)"uuidTimestampDecoder");
        this.filter = (UserEventFilter)ObjectUtils.requireNonNullArgument((Object)filter, (String)"filter");
        this.fetchSize = fetchSize;
        this.searchFilter = SearchFilter.forLDAPSearchFilterString((String)filter.getSearchFilter());
    }

    public String getSql() {
        StringBuilder buf = new StringBuilder();
        this.sqlCore(buf);
        this.sqlWhere(buf);
        this.sqlOrderBy(buf);
        CommonSqlUtils.limitOffset(this.filter, buf);
        return buf.toString();
    }

    private void sqlCore(StringBuilder buf) {
        buf.append("SELECT uel.user_id,uel.event_id,uel.tags,uel.message,uel.jdata\n");
        buf.append("FROM solaruser.user_event_log uel\n");
    }

    private void sqlWhere(StringBuilder buf) {
        StringBuilder where = new StringBuilder();
        int idx = 0;
        if (this.filter.hasUserCriteria()) {
            idx += CommonSqlUtils.whereOptimizedArrayContains(this.filter.getUserIds(), "uel.user_id", where);
        }
        if (this.filter.hasTagCriteria()) {
            where.append("\tAND uel.tags @> ?\n");
            ++idx;
        }
        if (this.searchFilter != null) {
            where.append("\tAND jsonb_path_exists(uel.jdata, ?::jsonpath)\n");
            ++idx;
        }
        if ((idx += CommonSqlUtils.whereDateRange(this.filter, "uel.event_id", where)) > 0) {
            buf.append("WHERE").append(where.substring(4));
        }
    }

    private void sqlOrderBy(StringBuilder buf) {
        buf.append("ORDER BY uel.user_id,uel.event_id");
    }

    public PreparedStatement createPreparedStatement(Connection con) throws SQLException {
        PreparedStatement stmt = con.prepareStatement(this.getSql(), 1003, 1007, 2);
        int p = this.prepareCore(con, stmt, 0);
        CommonSqlUtils.prepareLimitOffset(this.filter, con, stmt, p);
        if (this.fetchSize > 0) {
            stmt.setFetchSize(this.fetchSize);
        }
        return stmt;
    }

    private int prepareCore(Connection con, PreparedStatement stmt, int p) throws SQLException {
        if (this.filter.hasUserCriteria()) {
            p = CommonSqlUtils.prepareOptimizedArrayParameter(con, stmt, p, this.filter.getUserIds());
        }
        if (this.filter.hasTagCriteria()) {
            p = CommonSqlUtils.prepareArrayParameter(con, stmt, p, this.filter.getTags());
        }
        if (this.searchFilter != null) {
            stmt.setString(++p, SearchFilterUtils.toSqlJsonPath(this.searchFilter));
        }
        if (this.filter.getStartDate() != null) {
            stmt.setObject(++p, this.uuidTimestampDecoder.createTimestampBoundary(this.filter.getStartDate()));
        }
        if (this.filter.getEndDate() != null) {
            stmt.setObject(++p, this.uuidTimestampDecoder.createTimestampBoundary(this.filter.getEndDate()));
        }
        return p;
    }

    @Override
    public PreparedStatementCreator countPreparedStatementCreator() {
        return new CountPreparedStatementCreator();
    }

    private final class CountPreparedStatementCreator
    implements PreparedStatementCreator,
    SqlProvider {
        private CountPreparedStatementCreator() {
        }

        public String getSql() {
            StringBuilder buf = new StringBuilder();
            SelectUserEvent.this.sqlCore(buf);
            return CommonSqlUtils.wrappedCountQuery(buf.toString());
        }

        public PreparedStatement createPreparedStatement(Connection con) throws SQLException {
            PreparedStatement stmt = con.prepareStatement(this.getSql());
            SelectUserEvent.this.prepareCore(con, stmt, 0);
            return stmt;
        }
    }
}

