/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.central.common.dao.jdbc.sql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import net.solarnetwork.central.common.dao.jdbc.sql.CommonSqlUtils;
import net.solarnetwork.util.ObjectUtils;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.SqlProvider;

public class SelectSolarNodeOwnership
implements PreparedStatementCreator,
SqlProvider {
    private final Long[] nodeIds;
    private final Long[] userIds;

    public static SelectSolarNodeOwnership selectForNode(Long nodeId) {
        return new SelectSolarNodeOwnership(new Long[]{(Long)ObjectUtils.requireNonNullArgument((Object)nodeId, (String)"nodeId")}, null);
    }

    public static SelectSolarNodeOwnership selectForUser(Long userId) {
        return new SelectSolarNodeOwnership(null, new Long[]{(Long)ObjectUtils.requireNonNullArgument((Object)userId, (String)"userId")});
    }

    public static SelectSolarNodeOwnership selectForNodeUser(Long nodeId, Long userId) {
        return new SelectSolarNodeOwnership(new Long[]{(Long)ObjectUtils.requireNonNullArgument((Object)nodeId, (String)"nodeId")}, new Long[]{(Long)ObjectUtils.requireNonNullArgument((Object)userId, (String)"userId")});
    }

    public SelectSolarNodeOwnership(Long[] nodeIds, Long[] userIds) {
        this.nodeIds = nodeIds;
        this.userIds = userIds;
    }

    private void sqlCore(StringBuilder buf) {
        buf.append("SELECT un.node_id, un.user_id, l.country, l.time_zone, un.private, un.archived\n");
        buf.append("FROM solaruser.user_node un\n");
        buf.append("LEFT OUTER JOIN solarnet.sn_node n ON n.node_id = un.node_id\n");
        buf.append("LEFT OUTER JOIN solarnet.sn_loc l ON l.id = n.loc_id");
        this.sqlWhere(buf);
    }

    private void sqlWhere(StringBuilder buf) {
        boolean haveWhere = false;
        if (this.nodeIds != null && this.nodeIds.length > 0) {
            haveWhere = true;
            buf.append("\nWHERE un.node_id = ");
            if (this.nodeIds.length > 1) {
                buf.append("ANY(?)");
            } else {
                buf.append("?");
            }
        }
        if (this.userIds != null && this.userIds.length > 0) {
            if (!haveWhere) {
                buf.append("\nWHERE ");
                haveWhere = true;
            } else {
                buf.append("\nAND ");
            }
            buf.append("un.user_id = ");
            if (this.userIds.length > 1) {
                buf.append("ANY(?)");
            } else {
                buf.append("?");
            }
        }
    }

    private void sqlOrderBy(StringBuilder buf) {
        if (this.nodeIds != null && this.nodeIds.length == 1) {
            return;
        }
        buf.append("\nORDER BY un.node_id");
    }

    public String getSql() {
        StringBuilder buf = new StringBuilder();
        this.sqlCore(buf);
        this.sqlOrderBy(buf);
        return buf.toString();
    }

    public PreparedStatement createPreparedStatement(Connection con) throws SQLException {
        PreparedStatement stmt = con.prepareStatement(this.getSql(), 1003, 1007, 2);
        int p = 0;
        p = CommonSqlUtils.prepareOptimizedArrayParameter(con, stmt, p, this.nodeIds);
        p = CommonSqlUtils.prepareOptimizedArrayParameter(con, stmt, p, this.userIds);
        return stmt;
    }
}

