/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.central.common.dao.jdbc.sql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import net.solarnetwork.central.common.dao.LocationRequestCriteria;
import net.solarnetwork.central.common.dao.jdbc.sql.LocationRequestSqlUtils;
import net.solarnetwork.util.ObjectUtils;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.SqlProvider;

public class SelectLocationRequest
implements PreparedStatementCreator,
SqlProvider {
    private final Long id;
    private final LocationRequestCriteria filter;

    public SelectLocationRequest(Long id) {
        this.id = (Long)ObjectUtils.requireNonNullArgument((Object)id, (String)"id");
        this.filter = null;
    }

    public SelectLocationRequest(LocationRequestCriteria filter) {
        this.id = null;
        this.filter = (LocationRequestCriteria)ObjectUtils.requireNonNullArgument((Object)filter, (String)"filter");
    }

    public SelectLocationRequest(Long id, LocationRequestCriteria filter) {
        this.id = id;
        this.filter = filter;
    }

    public String getSql() {
        StringBuilder buf = new StringBuilder();
        buf.append("SELECT id, created, modified, user_id, status, jdata, loc_id, message\nFROM solarnet.sn_loc_req");
        StringBuilder where = new StringBuilder();
        LocationRequestSqlUtils.appendLocationRequestCriteria(this.id, this.filter, where);
        if (where.length() > 0) {
            buf.append(" WHERE").append(where.substring(4));
        }
        if (this.id == null) {
            buf.append("\nORDER BY id");
        }
        return buf.toString();
    }

    public PreparedStatement createPreparedStatement(Connection con) throws SQLException {
        PreparedStatement stmt = con.prepareStatement(this.getSql(), 1003, 1007, 2);
        LocationRequestSqlUtils.prepareLocationRequestCriteria(this.id, this.filter, con, stmt, 0);
        return stmt;
    }
}

