/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.central.common.dao.jdbc.sql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import net.solarnetwork.central.common.dao.jdbc.sql.CommonSqlUtils;
import net.solarnetwork.util.ObjectUtils;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.SqlProvider;

public class SelectAppSetting
implements PreparedStatementCreator,
SqlProvider {
    private final String[] keys;
    private final String[] types;
    private final boolean forUpdate;

    public static SelectAppSetting selectForKey(String key) {
        return SelectAppSetting.selectForKey(key, false);
    }

    public static SelectAppSetting selectForKey(String key, boolean forUpdate) {
        return new SelectAppSetting(new String[]{(String)ObjectUtils.requireNonNullArgument((Object)key, (String)"key")}, null, forUpdate);
    }

    public static SelectAppSetting selectForKeyType(String key, String type) {
        return SelectAppSetting.selectForKeyType(key, type, false);
    }

    public static SelectAppSetting selectForKeyType(String key, String type, boolean forUpdate) {
        return new SelectAppSetting(new String[]{(String)ObjectUtils.requireNonNullArgument((Object)key, (String)"key")}, new String[]{(String)ObjectUtils.requireNonNullArgument((Object)type, (String)"type")}, forUpdate);
    }

    public SelectAppSetting(String[] keys, String[] types) {
        this(keys, types, false);
    }

    public SelectAppSetting(String[] keys, String[] types, boolean forUpdate) {
        this.keys = keys;
        this.types = types;
        this.forUpdate = forUpdate;
    }

    private void sqlCore(StringBuilder buf) {
        buf.append("SELECT s.created, s.modified, s.skey, s.stype, s.svalue\n");
        buf.append("FROM solarcommon.app_setting s");
        this.sqlWhere(buf);
    }

    private void sqlWhere(StringBuilder buf) {
        boolean haveWhere = false;
        if (this.keys != null && this.keys.length > 0) {
            haveWhere = true;
            buf.append("\nWHERE s.skey = ");
            if (this.keys.length > 1) {
                buf.append("ANY(?)");
            } else {
                buf.append("?");
            }
        }
        if (this.types != null && this.types.length > 0) {
            if (!haveWhere) {
                buf.append("\nWHERE ");
                haveWhere = true;
            } else {
                buf.append("\nAND ");
            }
            buf.append("s.stype = ");
            if (this.types.length > 1) {
                buf.append("ANY(?)");
            } else {
                buf.append("?");
            }
        }
    }

    private void sqlOrderBy(StringBuilder buf) {
        if (this.keys != null && this.keys.length == 1 && this.types != null && this.types.length == 1) {
            return;
        }
        buf.append("\nORDER BY s.skey, s.stype");
    }

    public String getSql() {
        StringBuilder buf = new StringBuilder();
        this.sqlCore(buf);
        this.sqlOrderBy(buf);
        if (this.forUpdate) {
            CommonSqlUtils.forUpdate(false, buf);
        }
        return buf.toString();
    }

    public PreparedStatement createPreparedStatement(Connection con) throws SQLException {
        PreparedStatement stmt = CommonSqlUtils.createPreparedStatement(con, this.getSql(), this.forUpdate);
        int p = 0;
        p = CommonSqlUtils.prepareOptimizedArrayParameter(con, stmt, p, this.keys);
        p = CommonSqlUtils.prepareOptimizedArrayParameter(con, stmt, p, this.types);
        return stmt;
    }
}

