/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.central.common.dao.jdbc.sql;

import java.sql.Array;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import net.solarnetwork.central.common.dao.LocationRequestCriteria;
import net.solarnetwork.domain.Location;

public final class LocationRequestSqlUtils {
    public static int appendLocationRequestCriteria(Long id, LocationRequestCriteria filter, StringBuilder where) {
        int p = 0;
        if (id != null) {
            where.append("\tAND id = ?");
            ++p;
        }
        if (filter != null) {
            Location loc;
            if (filter.hasUserCriteria()) {
                where.append("\tAND user_id = ANY(?)");
                ++p;
            }
            if (filter.getLocationId() != null) {
                where.append("\tAND loc_id = ANY(?)");
                ++p;
            }
            if (filter.hasRequestStatusCriteria()) {
                where.append("\tAND status = ANY(?)");
                ++p;
            }
            if (filter.hasLocationCriteria() && (loc = filter.getLocation()).getName() != null) {
                where.append("\tAND fts_default @@ solarcommon.plainto_prefix_tsquery(?)");
                ++p;
            }
        }
        return p;
    }

    public static int prepareLocationRequestCriteria(Long id, LocationRequestCriteria filter, Connection con, PreparedStatement stmt, int p) throws SQLException {
        if (id != null) {
            stmt.setObject(++p, id);
        }
        if (filter != null) {
            Location loc;
            Array array;
            if (filter.hasUserCriteria()) {
                array = con.createArrayOf("BIGINT", filter.getUserIds());
                stmt.setArray(++p, array);
                array.free();
            }
            if (filter.getLocationId() != null) {
                array = con.createArrayOf("BIGINT", filter.getLocationIds());
                stmt.setArray(++p, array);
                array.free();
            }
            if (filter.hasRequestStatusCriteria()) {
                Object[] statuses = (String[])filter.getRequestStatuses().stream().map(e -> String.valueOf((char)e.getCode())).toArray(String[]::new);
                Array array2 = con.createArrayOf("TEXT", statuses);
                stmt.setArray(++p, array2);
                array2.free();
            }
            if (filter.hasLocationCriteria() && (loc = filter.getLocation()).getName() != null) {
                stmt.setString(++p, loc.getName());
            }
        }
        return p;
    }
}

