/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.central.common.dao.jdbc.sql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import net.solarnetwork.central.common.dao.jdbc.sql.CommonSqlUtils;
import net.solarnetwork.central.domain.UserEvent;
import net.solarnetwork.util.ObjectUtils;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.SqlProvider;

public class InsertUserEvent
implements PreparedStatementCreator,
SqlProvider {
    private static final String SQL = "INSERT INTO solaruser.user_event_log (user_id,event_id,tags,message,jdata)\nVALUES (?,?,?,?,?::jsonb)";
    private final UserEvent event;

    public InsertUserEvent(UserEvent event) {
        this.event = (UserEvent)ObjectUtils.requireNonNullArgument((Object)event, (String)"event");
    }

    public String getSql() {
        return SQL;
    }

    public PreparedStatement createPreparedStatement(Connection con) throws SQLException {
        PreparedStatement stmt = con.prepareStatement(this.getSql());
        stmt.setObject(1, this.event.getUserId());
        stmt.setObject(2, this.event.getEventId());
        CommonSqlUtils.prepareArrayParameter(con, stmt, 2, this.event.getTags());
        if (this.event.getMessage() != null) {
            stmt.setString(4, this.event.getMessage());
        } else {
            stmt.setNull(4, 12);
        }
        if (this.event.getData() != null) {
            stmt.setString(5, this.event.getData());
        } else {
            stmt.setNull(5, 12);
        }
        return stmt;
    }
}

