/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.central.common.dao.jdbc.sql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import net.solarnetwork.central.domain.LocationRequest;
import net.solarnetwork.util.ObjectUtils;
import org.springframework.jdbc.core.BatchPreparedStatementSetter;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.SqlProvider;

public class InsertLocationRequest
implements PreparedStatementCreator,
SqlProvider,
BatchPreparedStatementSetter {
    private final List<LocationRequest> requests;
    private final boolean batchMode;

    public InsertLocationRequest(LocationRequest request) {
        this(Collections.singletonList((LocationRequest)((Object)ObjectUtils.requireNonNullArgument((Object)((Object)request), (String)"request"))), false);
    }

    public InsertLocationRequest(List<LocationRequest> requests) {
        this(requests, true);
    }

    private InsertLocationRequest(List<LocationRequest> requests, boolean batchMode) {
        this.requests = (List)ObjectUtils.requireNonNullArgument(requests, (String)"requests");
        this.batchMode = batchMode;
    }

    public int getBatchSize() {
        return this.requests.size();
    }

    public String getSql() {
        return "INSERT INTO solarnet.sn_loc_req (user_id, loc_id, status, jdata)\nVALUES (?, ?, ?, ?::jsonb)";
    }

    public PreparedStatement createPreparedStatement(Connection con) throws SQLException {
        PreparedStatement stmt = con.prepareStatement(this.getSql(), 1);
        if (!this.batchMode) {
            this.setValues(stmt, 0);
        }
        return stmt;
    }

    public void setValues(PreparedStatement ps, int i) throws SQLException {
        LocationRequest req = this.requests.get(i);
        ps.setObject(1, req.getUserId());
        if (req.getLocationId() != null) {
            ps.setObject(2, req.getLocationId());
        } else {
            ps.setNull(2, -5);
        }
        ps.setString(3, String.valueOf((char)req.getStatus().getCode()));
        ps.setString(4, req.getJsonData());
    }
}

