/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.central.common.dao.jdbc.sql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Instant;
import net.solarnetwork.central.domain.AppSetting;
import net.solarnetwork.util.ObjectUtils;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.SqlProvider;

public class InsertAppSetting
implements PreparedStatementCreator,
SqlProvider {
    private final AppSetting setting;
    private final boolean upsert;

    public InsertAppSetting(AppSetting setting, boolean upsert) {
        this.setting = (AppSetting)ObjectUtils.requireNonNullArgument((Object)setting, (String)"setting");
        this.upsert = upsert;
    }

    public String getSql() {
        StringBuilder buf = new StringBuilder();
        buf.append("INSERT INTO solarcommon.app_setting (created, modified, skey, stype, svalue)\n");
        buf.append("VALUES (?,?,?,?,?)\n");
        if (this.upsert) {
            buf.append("ON CONFLICT (skey, stype) DO UPDATE\nSET ");
            if (this.setting.getModified() != null) {
                buf.append("modified = EXCLUDED.modified\n\t, ");
            }
            buf.append("svalue = EXCLUDED.svalue");
        }
        return buf.toString();
    }

    public PreparedStatement createPreparedStatement(Connection con) throws SQLException {
        PreparedStatement stmt = con.prepareStatement(this.getSql());
        Instant now = this.setting.getCreated() == null || this.setting.getModified() == null ? Instant.now() : null;
        int p = 0;
        stmt.setTimestamp(++p, Timestamp.from(this.setting.getCreated() != null ? this.setting.getCreated() : now));
        stmt.setTimestamp(++p, Timestamp.from(this.setting.getModified() != null ? this.setting.getModified() : now));
        stmt.setString(++p, this.setting.getKey());
        stmt.setString(++p, this.setting.getType());
        stmt.setString(++p, this.setting.getValue());
        return stmt;
    }
}

