/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.central.common.dao.jdbc.sql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.time.Instant;
import net.solarnetwork.central.common.dao.BasicUserEventFilter;
import net.solarnetwork.central.common.dao.UserEventMaintenanceDao;
import net.solarnetwork.central.common.dao.jdbc.sql.CommonSqlUtils;
import net.solarnetwork.util.ObjectUtils;
import net.solarnetwork.util.TimeBasedV7UuidGenerator;
import net.solarnetwork.util.UuidTimestampDecoder;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.SqlProvider;

public class DeleteUserEvent
implements PreparedStatementCreator,
SqlProvider {
    private final UuidTimestampDecoder uuidTimestampDecoder;
    private final UserEventMaintenanceDao.UserEventPurgeFilter filter;

    public static DeleteUserEvent deleteForUserOlderThanDate(Long userId, Instant date) {
        BasicUserEventFilter f = new BasicUserEventFilter();
        f.setUserId(userId);
        f.setEndDate(date);
        return new DeleteUserEvent(f);
    }

    public DeleteUserEvent(UserEventMaintenanceDao.UserEventPurgeFilter filter) {
        this((UuidTimestampDecoder)TimeBasedV7UuidGenerator.INSTANCE_MICROS, filter);
    }

    public DeleteUserEvent(UuidTimestampDecoder uuidTimestampDecoder, UserEventMaintenanceDao.UserEventPurgeFilter filter) {
        this.uuidTimestampDecoder = (UuidTimestampDecoder)ObjectUtils.requireNonNullArgument((Object)uuidTimestampDecoder, (String)"uuidTimestampDecoder");
        this.filter = (UserEventMaintenanceDao.UserEventPurgeFilter)ObjectUtils.requireNonNullArgument((Object)filter, (String)"filter");
        ObjectUtils.requireNonEmptyArgument((Object[])filter.getUserIds(), (String)"filter.userIds");
    }

    public String getSql() {
        StringBuilder buf = new StringBuilder();
        buf.append("DELETE FROM solaruser.user_event_log\n");
        this.sqlWhere(buf);
        return buf.toString();
    }

    private void sqlWhere(StringBuilder buf) {
        StringBuilder where = new StringBuilder();
        CommonSqlUtils.whereOptimizedArrayContains(this.filter.getUserIds(), "user_id", where);
        CommonSqlUtils.whereDateRange(this.filter, "event_id", where);
        buf.append("WHERE").append(where.substring(4));
    }

    public PreparedStatement createPreparedStatement(Connection con) throws SQLException {
        PreparedStatement stmt = con.prepareStatement(this.getSql());
        int p = 0;
        p = CommonSqlUtils.prepareOptimizedArrayParameter(con, stmt, p, this.filter.getUserIds());
        if (this.filter.getStartDate() != null) {
            stmt.setObject(++p, this.uuidTimestampDecoder.createTimestampBoundary(this.filter.getStartDate()));
        }
        if (this.filter.getEndDate() != null) {
            stmt.setObject(++p, this.uuidTimestampDecoder.createTimestampBoundary(this.filter.getEndDate()));
        }
        return stmt;
    }

    public UserEventMaintenanceDao.UserEventPurgeFilter getFilter() {
        return this.filter;
    }
}

