/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.central.common.dao.jdbc.sql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import net.solarnetwork.central.common.dao.LocationRequestCriteria;
import net.solarnetwork.central.common.dao.jdbc.sql.LocationRequestSqlUtils;
import net.solarnetwork.util.ObjectUtils;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.SqlProvider;

public class DeleteLocationRequest
implements PreparedStatementCreator,
SqlProvider {
    private final Long id;
    private final LocationRequestCriteria filter;

    public DeleteLocationRequest(Long id) {
        this((Long)ObjectUtils.requireNonNullArgument((Object)id, (String)"id"), null);
    }

    public DeleteLocationRequest(LocationRequestCriteria filter) {
        this(null, (LocationRequestCriteria)ObjectUtils.requireNonNullArgument((Object)filter, (String)"filter"));
    }

    public DeleteLocationRequest(Long id, LocationRequestCriteria filter) {
        this.id = id;
        this.filter = filter;
    }

    public String getSql() {
        StringBuilder buf = new StringBuilder(64);
        buf.append("DELETE FROM solarnet.sn_loc_req");
        StringBuilder where = new StringBuilder(64);
        LocationRequestSqlUtils.appendLocationRequestCriteria(this.id, this.filter, where);
        if (where.length() > 0) {
            buf.append(" WHERE").append(where.substring(4));
        }
        return buf.toString();
    }

    public PreparedStatement createPreparedStatement(Connection con) throws SQLException {
        PreparedStatement stmt = con.prepareStatement(this.getSql());
        LocationRequestSqlUtils.prepareLocationRequestCriteria(this.id, this.filter, con, stmt, 0);
        return stmt;
    }
}

