/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.central.common.dao.jdbc.sql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import net.solarnetwork.central.domain.CompositeKey;
import net.solarnetwork.util.ObjectUtils;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.SqlProvider;

public class DeleteForGroupMinimumIndex
implements PreparedStatementCreator,
SqlProvider {
    private final CompositeKey pk;
    private final String tableName;
    private final String[] columnNames;

    public DeleteForGroupMinimumIndex(CompositeKey pk, String tableName, String[] columnNames) {
        this.pk = (CompositeKey)ObjectUtils.requireNonNullArgument((Object)pk, (String)tableName);
        this.tableName = (String)ObjectUtils.requireNonNullArgument((Object)tableName, (String)"tableName");
        this.columnNames = (String[])ObjectUtils.requireNonEmptyArgument((Object[])columnNames, (String)"columnNames");
    }

    public String getSql() {
        StringBuilder buf = new StringBuilder();
        this.sqlCore(buf);
        this.sqlWhere(buf);
        return buf.toString();
    }

    private void sqlCore(StringBuilder buf) {
        buf.append(String.format("DELETE FROM %s\n", this.tableName));
    }

    private void sqlWhere(StringBuilder buf) {
        int i;
        StringBuilder where = new StringBuilder();
        int len = this.pk.keyComponentLength() - 1;
        for (i = 0; i < len; ++i) {
            if (!this.pk.keyComponentIsAssigned(i)) continue;
            where.append("\tAND ").append(this.columnNames[i]).append(" = ?\n");
        }
        where.append("\tAND ").append(this.columnNames[i]).append(" >= ?");
        buf.append("WHERE").append(where.substring(4));
    }

    public PreparedStatement createPreparedStatement(Connection con) throws SQLException {
        int i;
        PreparedStatement stmt = con.prepareStatement(this.getSql());
        int p = 0;
        int len = this.pk.keyComponentLength() - 1;
        for (i = 0; i < len; ++i) {
            if (!this.pk.keyComponentIsAssigned(i)) continue;
            stmt.setObject(++p, this.pk.keyComponent(i));
        }
        stmt.setObject(++p, this.pk.keyComponent(i));
        return stmt;
    }
}

