/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.central.common.dao.jdbc.sql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import net.solarnetwork.central.domain.CompositeKey;
import net.solarnetwork.util.ObjectUtils;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.SqlProvider;

public class DeleteForCompositeKey
implements PreparedStatementCreator,
SqlProvider {
    private final CompositeKey pk;
    private final String tableName;
    private final String[] columnNames;

    public DeleteForCompositeKey(CompositeKey pk, String tableName, String[] columnNames) {
        this.pk = (CompositeKey)ObjectUtils.requireNonNullArgument((Object)pk, (String)tableName);
        this.tableName = (String)ObjectUtils.requireNonNullArgument((Object)tableName, (String)"tableName");
        this.columnNames = (String[])ObjectUtils.requireNonEmptyArgument((Object[])columnNames, (String)"columnNames");
    }

    public String getSql() {
        StringBuilder buf = new StringBuilder();
        this.sqlCore(buf);
        this.sqlWhere(buf);
        return buf.toString();
    }

    private void sqlCore(StringBuilder buf) {
        buf.append(String.format("DELETE FROM %s\n", this.tableName));
    }

    private void sqlWhere(StringBuilder buf) {
        StringBuilder where = new StringBuilder();
        int idx = 0;
        int len = this.pk.keyComponentLength();
        for (int i = 0; i < len; ++i) {
            if (!this.pk.keyComponentIsAssigned(i)) continue;
            where.append(" AND ").append(this.columnNames[i]).append(" = ?");
            ++idx;
        }
        if (idx > 0) {
            buf.append("WHERE").append(where.substring(4));
        }
    }

    public PreparedStatement createPreparedStatement(Connection con) throws SQLException {
        PreparedStatement stmt = con.prepareStatement(this.getSql());
        int p = 0;
        int len = this.pk.keyComponentLength();
        for (int i = 0; i < len; ++i) {
            if (!this.pk.keyComponentIsAssigned(i)) continue;
            stmt.setObject(++p, this.pk.keyComponent(i));
        }
        return stmt;
    }
}

