/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.central.common.dao.jdbc.sql;

import java.sql.Array;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Pattern;
import net.solarnetwork.codec.JsonUtils;
import net.solarnetwork.dao.DateRangeCriteria;
import net.solarnetwork.dao.PaginationCriteria;
import net.solarnetwork.domain.CodedValue;
import net.solarnetwork.domain.SortDescriptor;

public final class CommonSqlUtils {
    public static final Pattern SQL_COMMENT = Pattern.compile("^\\s*--");
    public static final int WHERE_COMPONENT_PREFIX_LENGTH = 4;

    public static int prepareOptimizedArrayParameter(Connection con, PreparedStatement stmt, int parameterOffset, Integer[] value) throws SQLException {
        return CommonSqlUtils.prepareOptimizedArrayParameter(con, stmt, parameterOffset, "integer", value);
    }

    public static int prepareOptimizedArrayParameter(Connection con, PreparedStatement stmt, int parameterOffset, Long[] value) throws SQLException {
        return CommonSqlUtils.prepareOptimizedArrayParameter(con, stmt, parameterOffset, "bigint", value);
    }

    public static int prepareOptimizedArrayParameter(Connection con, PreparedStatement stmt, int parameterOffset, Long[] value, boolean setNull) throws SQLException {
        return CommonSqlUtils.prepareOptimizedArrayParameter(con, stmt, parameterOffset, "text", value, setNull);
    }

    public static int prepareOptimizedArrayParameter(Connection con, PreparedStatement stmt, int parameterOffset, String[] value) throws SQLException {
        return CommonSqlUtils.prepareOptimizedArrayParameter(con, stmt, parameterOffset, "text", value);
    }

    public static int prepareOptimizedArrayParameter(Connection con, PreparedStatement stmt, int parameterOffset, String[] value, boolean setNull) throws SQLException {
        return CommonSqlUtils.prepareOptimizedArrayParameter(con, stmt, parameterOffset, "text", value, setNull);
    }

    public static int prepareOptimizedArrayParameter(Connection con, PreparedStatement stmt, int parameterOffset, UUID[] value) throws SQLException {
        return CommonSqlUtils.prepareOptimizedArrayParameter(con, stmt, parameterOffset, "uuid", value);
    }

    public static int prepareOptimizedArrayParameter(Connection con, PreparedStatement stmt, int parameterOffset, UUID[] value, boolean setNull) throws SQLException {
        return CommonSqlUtils.prepareOptimizedArrayParameter(con, stmt, parameterOffset, "uuid", value, setNull);
    }

    public static int prepareOptimizedArrayParameter(Connection con, PreparedStatement stmt, int parameterOffset, String arrayType, Object[] value) throws SQLException {
        return CommonSqlUtils.prepareOptimizedArrayParameter(con, stmt, parameterOffset, arrayType, value, false);
    }

    public static int prepareOptimizedArrayParameter(Connection con, PreparedStatement stmt, int parameterOffset, String arrayType, Object[] value, boolean setNull) throws SQLException {
        if (value != null) {
            if (value.length > 1) {
                Array array = con.createArrayOf(arrayType, value);
                stmt.setArray(++parameterOffset, array);
                array.free();
            } else {
                stmt.setObject(++parameterOffset, value[0]);
            }
        } else if (setNull) {
            stmt.setNull(++parameterOffset, 2003);
        }
        return parameterOffset;
    }

    public static int prepareArrayParameter(Connection con, PreparedStatement stmt, int parameterOffset, Integer[] value) throws SQLException {
        return CommonSqlUtils.prepareArrayParameter(con, stmt, parameterOffset, value, false);
    }

    public static int prepareArrayParameter(Connection con, PreparedStatement stmt, int parameterOffset, Integer[] value, boolean setNull) throws SQLException {
        return CommonSqlUtils.prepareArrayParameter(con, stmt, parameterOffset, "integer", value, setNull);
    }

    public static int prepareArrayParameter(Connection con, PreparedStatement stmt, int parameterOffset, Long[] value) throws SQLException {
        return CommonSqlUtils.prepareArrayParameter(con, stmt, parameterOffset, value, false);
    }

    public static int prepareArrayParameter(Connection con, PreparedStatement stmt, int parameterOffset, Long[] value, boolean setNull) throws SQLException {
        return CommonSqlUtils.prepareArrayParameter(con, stmt, parameterOffset, "bigint", value, setNull);
    }

    public static int prepareArrayParameter(Connection con, PreparedStatement stmt, int parameterOffset, String[] value) throws SQLException {
        return CommonSqlUtils.prepareArrayParameter(con, stmt, parameterOffset, "text", value);
    }

    public static int prepareArrayParameter(Connection con, PreparedStatement stmt, int parameterOffset, String[] value, boolean setNull) throws SQLException {
        return CommonSqlUtils.prepareArrayParameter(con, stmt, parameterOffset, "text", value, setNull);
    }

    public static int prepareArrayParameter(Connection con, PreparedStatement stmt, int parameterOffset, UUID[] value) throws SQLException {
        return CommonSqlUtils.prepareArrayParameter(con, stmt, parameterOffset, "uuid", value);
    }

    public static int prepareArrayParameter(Connection con, PreparedStatement stmt, int parameterOffset, UUID[] value, boolean setNull) throws SQLException {
        return CommonSqlUtils.prepareArrayParameter(con, stmt, parameterOffset, "uuid", value, setNull);
    }

    public static int prepareArrayParameter(Connection con, PreparedStatement stmt, int parameterOffset, String arrayType, Object[] value) throws SQLException {
        return CommonSqlUtils.prepareArrayParameter(con, stmt, parameterOffset, arrayType, value, false);
    }

    public static int prepareArrayParameter(Connection con, PreparedStatement stmt, int parameterOffset, String arrayType, Object[] value, boolean setNull) throws SQLException {
        if (value != null) {
            Array array = con.createArrayOf(arrayType, value);
            stmt.setArray(++parameterOffset, array);
            array.free();
        } else if (setNull) {
            stmt.setNull(++parameterOffset, 2003);
        }
        return parameterOffset;
    }

    public static void forUpdate(boolean skipLocked, StringBuilder buf) {
        CommonSqlUtils.forUpdate(skipLocked, null, buf);
    }

    public static void forUpdate(boolean skipLocked, String[] tableNames, StringBuilder buf) {
        buf.append("\nFOR UPDATE");
        if (tableNames != null && tableNames.length > 0) {
            buf.append(" OF");
            int i = 0;
            for (String tableName : tableNames) {
                if (i++ > 0) {
                    buf.append(',');
                }
                buf.append(' ');
                buf.append(tableName);
            }
        }
        if (skipLocked) {
            buf.append(" SKIP LOCKED");
        }
    }

    public static int limitOffset(PaginationCriteria filter, StringBuilder buf) {
        int offset;
        int max;
        int result = 0;
        if (filter != null && filter.getMax() != null && (max = filter.getMax().intValue()) > 0) {
            buf.append("\nLIMIT ?");
            ++result;
        }
        if (filter != null && filter.getOffset() != null && (offset = filter.getOffset().intValue()) > 0) {
            if (result < 1) {
                buf.append('\n');
            } else {
                buf.append(' ');
            }
            buf.append("OFFSET ?");
            ++result;
        }
        return result;
    }

    public static int prepareLimitOffset(PaginationCriteria filter, Connection con, PreparedStatement stmt, int parameterOffset) throws SQLException {
        int offset;
        int max;
        if (filter != null && filter.getMax() != null && (max = filter.getMax().intValue()) > 0) {
            stmt.setInt(++parameterOffset, max);
        }
        if (filter != null && filter.getOffset() != null && (offset = filter.getOffset().intValue()) > 0) {
            stmt.setInt(++parameterOffset, offset);
        }
        return parameterOffset;
    }

    public static String wrappedCountQuery(String sql) {
        return "SELECT COUNT(*) FROM (" + sql + ") AS q";
    }

    public static void limitOffsetLiteral(PaginationCriteria filter, StringBuilder buf) {
        if (filter != null && filter.getMax() != null) {
            Integer offset;
            int max = filter.getMax();
            if (max > 0) {
                buf.append("\nLIMIT ").append(max);
            }
            if ((offset = filter.getOffset()) != null) {
                buf.append(" OFFSET ").append(offset);
            }
        }
    }

    public static PreparedStatement createPreparedStatement(Connection con, String sql, boolean forUpdate) throws SQLException {
        PreparedStatement stmt = forUpdate ? con.prepareStatement(sql, 1004, 1008) : con.prepareStatement(sql, 1003, 1007, 2);
        return stmt;
    }

    public static int whereArrayColContains(Object[] array, String colName, StringBuilder buf) {
        if (array != null && array.length > 0) {
            buf.append("\tAND ").append(colName).append(" @> ?\n");
            return 1;
        }
        return 0;
    }

    public static int whereOptimizedArrayContains(Object[] array, String colName, StringBuilder buf) {
        int paramCount = 0;
        if (array != null && array.length > 0) {
            buf.append("\tAND ").append(colName).append(" = ");
            if (array.length > 1) {
                buf.append("ANY(?)");
            } else {
                buf.append("?");
            }
            buf.append("\n");
            paramCount = 1;
        }
        return paramCount;
    }

    public static int whereDateRange(DateRangeCriteria filter, String colName, StringBuilder buf) {
        int paramCount = 0;
        if (filter.getStartDate() != null) {
            buf.append("\tAND ").append(colName).append(" >= ?\n");
            ++paramCount;
        }
        if (filter.getEndDate() != null) {
            buf.append("\tAND ").append(colName).append(" < ?\n");
            ++paramCount;
        }
        return paramCount;
    }

    public static int prepareDateRange(DateRangeCriteria filter, PreparedStatement stmt, int parameterOffset) throws SQLException {
        if (filter.getStartDate() != null) {
            stmt.setTimestamp(++parameterOffset, Timestamp.from(filter.getStartDate()));
        }
        if (filter.getEndDate() != null) {
            stmt.setTimestamp(++parameterOffset, Timestamp.from(filter.getEndDate()));
        }
        return parameterOffset;
    }

    public static int prepareJsonString(Object data, PreparedStatement stmt, int parameterOffset, boolean setNull) throws SQLException {
        String props = JsonUtils.getJSONString((Object)data, null);
        if (props != null) {
            stmt.setString(++parameterOffset, props);
        } else if (setNull) {
            stmt.setNull(++parameterOffset, 12);
        }
        return parameterOffset;
    }

    public static int prepareCodedValue(PreparedStatement stmt, int parameterOffset, CodedValue value, CodedValue defaultValue, boolean setNull) throws SQLException {
        if (value != null) {
            stmt.setInt(++parameterOffset, value.getCode());
        } else if (defaultValue != null) {
            stmt.setInt(++parameterOffset, defaultValue.getCode());
        } else if (setNull) {
            stmt.setNull(++parameterOffset, 4);
        }
        return parameterOffset;
    }

    public static int prepareCodedValueChar(PreparedStatement stmt, int parameterOffset, CodedValue value, CodedValue defaultValue, boolean setNull) throws SQLException {
        if (value != null) {
            stmt.setObject(++parameterOffset, Character.valueOf((char)value.getCode()));
        } else if (defaultValue != null) {
            stmt.setObject(++parameterOffset, Character.valueOf((char)defaultValue.getCode()));
        } else if (setNull) {
            stmt.setNull(++parameterOffset, 1);
        }
        return parameterOffset;
    }

    public static int prepareCodedValuesArray(Connection con, PreparedStatement stmt, int parameterOffset, Collection<? extends CodedValue> values, boolean setNull) throws SQLException {
        Integer[] codes = null;
        if (values != null) {
            codes = (Integer[])values.stream().map(CodedValue::getCode).toArray(Integer[]::new);
        }
        return CommonSqlUtils.prepareArrayParameter(con, stmt, parameterOffset, codes, setNull);
    }

    public static int orderBySorts(Iterable<SortDescriptor> sorts, Map<String, String> sortKeyMapping, StringBuilder buf) {
        if (sorts == null || sortKeyMapping == null || sortKeyMapping.isEmpty()) {
            return 0;
        }
        boolean appended = false;
        for (SortDescriptor sort : sorts) {
            String sqlName = sortKeyMapping.get(sort.getSortKey());
            if (sqlName == null) continue;
            appended = true;
            buf.append(", ").append(sqlName);
            if (!sort.isDescending()) continue;
            buf.append(" DESC");
        }
        return appended ? 2 : 0;
    }
}

