/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.central.common.dao.jdbc.sql;

import java.io.IOException;
import java.sql.Array;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.solarnetwork.central.common.dao.jdbc.CountPreparedStatementCreatorProvider;
import net.solarnetwork.central.support.FilteredResultsProcessor;
import net.solarnetwork.dao.BasicFilterResults;
import net.solarnetwork.dao.FilterResults;
import net.solarnetwork.dao.OptimizedQueryCriteria;
import net.solarnetwork.dao.PaginationCriteria;
import net.solarnetwork.domain.CodedValue;
import net.solarnetwork.domain.Identity;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.PreparedStatementCallback;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;

public final class CommonJdbcUtils {
    private CommonJdbcUtils() {
    }

    public static <T> T getArray(ResultSet rs, int colNum) throws SQLException {
        Array a = rs.getArray(colNum);
        if (a == null) {
            return null;
        }
        return (T)a.getArray();
    }

    public static <T> T arrayValue(Object o) {
        if (o instanceof Array) {
            Array a = (Array)o;
            try {
                return (T)a.getArray();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return null;
    }

    public static UUID getUuid(ResultSet rs, int column) throws SQLException {
        Object sid = rs.getObject(column);
        return sid instanceof UUID ? (UUID)sid : (sid != null ? UUID.fromString(sid.toString()) : null);
    }

    public static Long executeCountQuery(JdbcOperations jdbcTemplate, PreparedStatementCreator creator) {
        return (Long)jdbcTemplate.query(creator, (ResultSetExtractor)new ResultSetExtractor<Long>(){

            public Long extractData(ResultSet rs) throws SQLException, DataAccessException {
                return rs.next() ? Long.valueOf(rs.getLong(1)) : null;
            }
        });
    }

    public static <M extends Identity<K>, K> FilterResults<M, K> executeFilterQuery(JdbcOperations jdbcTemplate, PaginationCriteria filter, PreparedStatementCreator sql, RowMapper<M> mapper) {
        Long totalCount = null;
        if (!(filter.getMax() == null || !(sql instanceof CountPreparedStatementCreatorProvider) || filter instanceof OptimizedQueryCriteria && ((OptimizedQueryCriteria)filter).isWithoutTotalResultsCount())) {
            totalCount = CommonJdbcUtils.executeCountQuery(jdbcTemplate, ((CountPreparedStatementCreatorProvider)sql).countPreparedStatementCreator());
        }
        List results = jdbcTemplate.query(sql, mapper);
        if (filter.getMax() == null) {
            totalCount = results.size();
        }
        int offset = filter.getOffset() != null ? filter.getOffset() : 0;
        return new BasicFilterResults((Iterable)results, totalCount, offset, results.size());
    }

    public static <T> void executeStreamingQuery(JdbcOperations jdbcOps, FilteredResultsProcessor<T> processor, PreparedStatementCreator sql, RowMapper<T> mapper) throws IOException {
        CommonJdbcUtils.executeStreamingQuery(jdbcOps, processor, sql, mapper, null, null, null, Collections.emptyMap());
    }

    public static <T> void executeStreamingQuery(JdbcOperations jdbcOps, final FilteredResultsProcessor<T> processor, PreparedStatementCreator sql, final RowMapper<T> mapper, Long totalResultCount, Integer startingOffset, Integer expectedResultCount, Map<String, ?> attributes) throws IOException {
        processor.start(totalResultCount, startingOffset, expectedResultCount, attributes);
        try {
            jdbcOps.execute(sql, (PreparedStatementCallback)new PreparedStatementCallback<Void>(){

                public Void doInPreparedStatement(PreparedStatement ps) throws SQLException, DataAccessException {
                    try (ResultSet rs = ps.executeQuery();){
                        int row = 0;
                        while (rs.next()) {
                            Object entity = mapper.mapRow(rs, ++row);
                            processor.handleResultItem(entity);
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    return null;
                }
            });
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw e;
        }
    }

    public static Long updateWithGeneratedLong(JdbcOperations jdbcTemplate, PreparedStatementCreator sql, String keyColumnName) {
        GeneratedKeyHolder keyHolder = new GeneratedKeyHolder();
        jdbcTemplate.update(sql, (KeyHolder)keyHolder);
        Map keys = keyHolder.getKeys();
        Object id = keys.get(keyColumnName);
        return id instanceof Long ? (Long)id : null;
    }

    public static <T extends Enum<T>> Set<T> getCodedValueSet(ResultSet rs, int colNum, Class<T> clazz) throws SQLException {
        Number[] codes = (Number[])CommonJdbcUtils.getArray(rs, colNum);
        if (codes == null) {
            return null;
        }
        LinkedHashSet<Enum> result = new LinkedHashSet<Enum>(codes.length);
        block0: for (Number code : codes) {
            int c = code.intValue();
            for (Enum e : (Enum[])clazz.getEnumConstants()) {
                if (c != ((CodedValue)e).getCode()) continue;
                result.add(e);
                continue block0;
            }
        }
        return result;
    }

    public static Instant getTimestampInstant(ResultSet rs, int column) throws SQLException {
        Timestamp ts = rs.getTimestamp(column);
        return ts != null ? ts.toInstant() : null;
    }
}

