/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.central.common.dao.jdbc;

import java.time.Clock;
import java.time.Duration;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.sql.DataSource;
import net.solarnetwork.central.biz.UserServiceAuditor;
import net.solarnetwork.central.common.dao.jdbc.JdbcNodeServiceAuditor;
import net.solarnetwork.domain.datum.DatumId;
import net.solarnetwork.util.StatTracker;
import org.slf4j.LoggerFactory;

public class JdbcUserServiceAuditor
extends JdbcNodeServiceAuditor
implements UserServiceAuditor {
    public static final String DEFAULT_USER_SERVICE_INCREMENT_SQL = "{call solardatm.audit_increment_user_count(?,?,?,?)}";

    public JdbcUserServiceAuditor(DataSource dataSource) {
        this(dataSource, new ConcurrentHashMap<DatumId, AtomicInteger>(1000, 0.8f, 4), Clock.tick(Clock.systemUTC(), Duration.ofHours(1L)), new StatTracker("UserServiceAuditor", null, LoggerFactory.getLogger(JdbcUserServiceAuditor.class), 1000));
    }

    public JdbcUserServiceAuditor(DataSource dataSource, ConcurrentMap<DatumId, AtomicInteger> userServiceCounters, Clock clock, StatTracker statCounter) {
        super(dataSource, userServiceCounters, clock, statCounter);
        this.setNodeServiceIncrementSql(DEFAULT_USER_SERVICE_INCREMENT_SQL);
    }

    @Override
    public void auditUserService(Long userId, String service, int count) {
        this.auditNodeService(userId, service, count);
    }
}

