/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.central.common.dao.jdbc;

import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import net.solarnetwork.central.common.dao.UserEventDao;
import net.solarnetwork.central.common.dao.UserEventFilter;
import net.solarnetwork.central.common.dao.UserEventMaintenanceDao;
import net.solarnetwork.central.common.dao.jdbc.UserEventRowMapper;
import net.solarnetwork.central.common.dao.jdbc.sql.CommonJdbcUtils;
import net.solarnetwork.central.common.dao.jdbc.sql.DeleteUserEvent;
import net.solarnetwork.central.common.dao.jdbc.sql.InsertUserEvent;
import net.solarnetwork.central.common.dao.jdbc.sql.SelectUserEvent;
import net.solarnetwork.central.domain.UserEvent;
import net.solarnetwork.central.domain.UserUuidPK;
import net.solarnetwork.central.support.FilteredResultsProcessor;
import net.solarnetwork.dao.FilterResults;
import net.solarnetwork.domain.SortDescriptor;
import net.solarnetwork.util.ObjectUtils;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.PreparedStatementCallback;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.RowMapper;

public class JdbcUserEventDao
implements UserEventDao,
UserEventMaintenanceDao {
    private final JdbcOperations jdbcOps;

    public JdbcUserEventDao(JdbcOperations jdbcOps) {
        this.jdbcOps = (JdbcOperations)ObjectUtils.requireNonNullArgument((Object)jdbcOps, (String)"jdbcOps");
    }

    @Override
    public void add(UserEvent event) {
        InsertUserEvent sql = new InsertUserEvent(event);
        this.jdbcOps.update((PreparedStatementCreator)sql);
    }

    public FilterResults<UserEvent, UserUuidPK> findFiltered(UserEventFilter filter, List<SortDescriptor> sorts, Integer offset, Integer max) {
        SelectUserEvent sql = new SelectUserEvent(filter);
        return CommonJdbcUtils.executeFilterQuery(this.jdbcOps, filter, sql, UserEventRowMapper.INSTANCE);
    }

    @Override
    public long purgeEvents(UserEventMaintenanceDao.UserEventPurgeFilter filter) {
        DeleteUserEvent sql = new DeleteUserEvent(filter);
        return this.jdbcOps.update((PreparedStatementCreator)sql);
    }

    @Override
    public void findFilteredStream(UserEventFilter filter, final FilteredResultsProcessor<UserEvent> processor) throws IOException {
        ObjectUtils.requireNonNullArgument((Object)filter, (String)"filter");
        ObjectUtils.requireNonNullArgument(processor, (String)"processor");
        SelectUserEvent sql = new SelectUserEvent(filter);
        final RowMapper<UserEvent> mapper = UserEventRowMapper.INSTANCE;
        processor.start(null, null, null, Collections.emptyMap());
        try {
            this.jdbcOps.execute((PreparedStatementCreator)sql, (PreparedStatementCallback)new PreparedStatementCallback<Void>(){

                public Void doInPreparedStatement(PreparedStatement ps) throws SQLException, DataAccessException {
                    try (ResultSet rs = ps.executeQuery();){
                        int row = 0;
                        while (rs.next()) {
                            UserEvent event = (UserEvent)mapper.mapRow(rs, ++row);
                            processor.handleResultItem(event);
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    return null;
                }
            });
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw e;
        }
    }
}

