/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.central.common.dao.jdbc;

import java.util.List;
import javax.cache.Cache;
import net.solarnetwork.central.common.dao.jdbc.BasicSolarNodeOwnershipRowMapper;
import net.solarnetwork.central.common.dao.jdbc.ColumnRowMapper;
import net.solarnetwork.central.common.dao.jdbc.sql.SelectSolarNodeOwnership;
import net.solarnetwork.central.common.dao.jdbc.sql.SelectUserAuthTokenNodes;
import net.solarnetwork.central.dao.SolarNodeOwnershipDao;
import net.solarnetwork.central.domain.SolarNodeOwnership;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.PreparedStatementCreator;

public class JdbcSolarNodeOwnershipDao
implements SolarNodeOwnershipDao {
    private final JdbcOperations jdbcOps;
    private Cache<Long, SolarNodeOwnership> nodeOwnershipCache;

    public JdbcSolarNodeOwnershipDao(JdbcOperations jdbcOps) {
        this.jdbcOps = jdbcOps;
    }

    @Override
    public SolarNodeOwnership ownershipForNodeId(Long nodeId) {
        if (nodeId == null) {
            return null;
        }
        SolarNodeOwnership result = null;
        Cache<Long, SolarNodeOwnership> cache = this.getNodeOwnershipCache();
        if (cache != null && (result = (SolarNodeOwnership)cache.get((Object)nodeId)) != null) {
            return result;
        }
        List results = this.getJdbcOps().query((PreparedStatementCreator)SelectSolarNodeOwnership.selectForNode(nodeId), BasicSolarNodeOwnershipRowMapper.INSTANCE);
        if (results != null && !results.isEmpty() && (result = (SolarNodeOwnership)results.get(0)) != null && cache != null) {
            cache.put((Object)nodeId, (Object)result);
        }
        return result;
    }

    @Override
    public SolarNodeOwnership[] ownershipsForUserId(Long userId) {
        if (userId == null) {
            return null;
        }
        SolarNodeOwnership[] result = null;
        List results = this.getJdbcOps().query((PreparedStatementCreator)SelectSolarNodeOwnership.selectForUser(userId), BasicSolarNodeOwnershipRowMapper.INSTANCE);
        if (results != null && !results.isEmpty()) {
            result = results.toArray(new SolarNodeOwnership[results.size()]);
        }
        return result;
    }

    @Override
    public Long[] nonArchivedNodeIdsForToken(String tokenId) {
        if (tokenId == null) {
            return new Long[0];
        }
        List results = this.getJdbcOps().query((PreparedStatementCreator)new SelectUserAuthTokenNodes(tokenId), new ColumnRowMapper<Long>(2, Long.class));
        return results != null ? (Long[])results.toArray(Long[]::new) : new Long[]{};
    }

    public JdbcOperations getJdbcOps() {
        return this.jdbcOps;
    }

    public Cache<Long, SolarNodeOwnership> getNodeOwnershipCache() {
        return this.nodeOwnershipCache;
    }

    public void setUserNodeCache(Cache<Long, SolarNodeOwnership> nodeOwnershipCache) {
        this.nodeOwnershipCache = nodeOwnershipCache;
    }
}

