/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.central.common.dao.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import net.solarnetwork.central.biz.NodeServiceAuditor;
import net.solarnetwork.central.common.dao.jdbc.JdbcNodeServiceAuditorCount;
import net.solarnetwork.domain.datum.DatumId;
import net.solarnetwork.service.PingTest;
import net.solarnetwork.service.PingTestResult;
import net.solarnetwork.service.ServiceLifecycleObserver;
import net.solarnetwork.util.ObjectUtils;
import net.solarnetwork.util.StatTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcNodeServiceAuditor
implements NodeServiceAuditor,
PingTest,
ServiceLifecycleObserver {
    public static final long DEFAULT_UPDATE_DELAY = 100L;
    public static final long DEFAULT_FLUSH_DELAY = 10000L;
    public static final long DEFAULT_CONNECTION_RECOVERY_DELAY = 15000L;
    public static final String DEFAULT_NODE_SERVICE_INCREMENT_SQL = "{call solardatm.audit_increment_node_count(?,?,?,?)}";
    public static final Pattern CALLABLE_STATEMENT_REGEX = Pattern.compile("^\\{call\\s.*\\}", 2);
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private final DataSource dataSource;
    private final ConcurrentMap<DatumId, AtomicInteger> nodeServiceCounters;
    private final Clock clock;
    private final StatTracker statCounter;
    private String nodeServiceIncrementSql;
    private WriterThread writerThread;
    private long updateDelay;
    private long flushDelay;
    private long connectionRecoveryDelay;

    public JdbcNodeServiceAuditor(DataSource dataSource) {
        this(dataSource, new ConcurrentHashMap<DatumId, AtomicInteger>(1000, 0.8f, 4), Clock.tick(Clock.systemUTC(), Duration.ofHours(1L)), new StatTracker("NodeServiceAuditor", null, LoggerFactory.getLogger(JdbcNodeServiceAuditor.class), 1000));
    }

    public JdbcNodeServiceAuditor(DataSource dataSource, ConcurrentMap<DatumId, AtomicInteger> nodeServiceCounters, Clock clock, StatTracker statCounter) {
        this.dataSource = (DataSource)ObjectUtils.requireNonNullArgument((Object)dataSource, (String)"dataSource");
        this.nodeServiceCounters = (ConcurrentMap)ObjectUtils.requireNonNullArgument(nodeServiceCounters, (String)"nodeServiceCounters");
        this.clock = (Clock)ObjectUtils.requireNonNullArgument((Object)clock, (String)"clock");
        this.statCounter = (StatTracker)ObjectUtils.requireNonNullArgument((Object)statCounter, (String)"statCounter");
        this.setConnectionRecoveryDelay(15000L);
        this.setFlushDelay(10000L);
        this.setUpdateDelay(100L);
        this.setNodeServiceIncrementSql(DEFAULT_NODE_SERVICE_INCREMENT_SQL);
    }

    public void serviceDidStartup() {
        this.enableWriting();
    }

    public void serviceDidShutdown() {
        this.disableWriting();
    }

    @Override
    public Clock getAuditClock() {
        return this.clock;
    }

    @Override
    public void auditNodeService(Long nodeId, String service, int count) {
        if (count == 0) {
            return;
        }
        this.addNodeServiceCount(DatumId.nodeId((Long)nodeId, (String)service, (Instant)this.clock.instant()), count);
    }

    private void addNodeServiceCount(DatumId key, int count) {
        this.nodeServiceCounters.computeIfAbsent(key, k -> new AtomicInteger(0)).addAndGet(count);
        this.statCounter.increment((Enum)JdbcNodeServiceAuditorCount.ResultsAdded);
    }

    private void flushNodeServiceData(PreparedStatement stmt) throws SQLException, InterruptedException {
        this.statCounter.increment((Enum)JdbcNodeServiceAuditorCount.CountsFlushed);
        Iterator itr = this.nodeServiceCounters.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry me = itr.next();
            DatumId key = (DatumId)me.getKey();
            AtomicInteger counter = (AtomicInteger)me.getValue();
            int count = counter.getAndSet(0);
            if (count < 1) {
                itr.remove();
                this.statCounter.increment((Enum)JdbcNodeServiceAuditorCount.ZeroCountsCleared);
                continue;
            }
            try {
                if (this.log.isTraceEnabled()) {
                    this.log.trace("Incrementing node {} service {} @ {} count by {}", new Object[]{key.getObjectId(), key.getSourceId(), key.getTimestamp(), count});
                }
                stmt.setObject(1, key.getObjectId());
                stmt.setString(2, key.getSourceId());
                stmt.setTimestamp(3, Timestamp.from(key.getTimestamp()));
                stmt.setInt(4, count);
                stmt.execute();
                this.statCounter.increment((Enum)JdbcNodeServiceAuditorCount.UpdatesExecuted);
                if (this.updateDelay <= 0L) continue;
                Thread.sleep(this.updateDelay);
            }
            catch (InterruptedException | SQLException e) {
                this.statCounter.increment((Enum)JdbcNodeServiceAuditorCount.UpdatesFailed);
                this.addNodeServiceCount(key, count);
                this.statCounter.increment((Enum)JdbcNodeServiceAuditorCount.ResultsReadded);
                throw e;
            }
            catch (Exception e) {
                this.statCounter.increment((Enum)JdbcNodeServiceAuditorCount.UpdatesFailed);
                this.addNodeServiceCount(key, count);
                this.statCounter.increment((Enum)JdbcNodeServiceAuditorCount.ResultsReadded);
                RuntimeException re = e instanceof RuntimeException ? (RuntimeException)e : new RuntimeException("Exception flushing node source audit data", e);
                throw re;
            }
        }
    }

    private boolean isCallableStatement(String sql) {
        Matcher m = CALLABLE_STATEMENT_REGEX.matcher(sql);
        return m.matches();
    }

    public synchronized void reconnectWriter() {
        if (this.writerThread != null && this.writerThread.isGoing()) {
            this.writerThread.reconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void enableWriting() {
        if (this.writerThread == null || !this.writerThread.isGoing()) {
            this.writerThread = new WriterThread();
            this.writerThread.setName("JdbcNodeServiceAuditorWriter");
            WriterThread writerThread = this.writerThread;
            synchronized (writerThread) {
                this.writerThread.start();
                while (!this.writerThread.hasStarted()) {
                    try {
                        this.writerThread.wait(5000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    public synchronized void disableWriting() {
        if (this.writerThread != null) {
            this.writerThread.exit();
        }
    }

    public String getPingTestId() {
        return this.getClass().getName();
    }

    public String getPingTestName() {
        return "JDBC Query Auditor";
    }

    public long getPingTestMaximumExecutionMilliseconds() {
        return 1000L;
    }

    public PingTest.Result performPingTest() throws Exception {
        WriterThread t = this.writerThread;
        boolean writerRunning = t != null && t.isAlive();
        NavigableMap statMap = this.statCounter.allCounts();
        if (!writerRunning) {
            return new PingTestResult(false, this.writerThread == null ? "Writer thread missing." : "Writer thread dead.", (Map)statMap);
        }
        return new PingTestResult(true, "Writer thread alive.", (Map)statMap);
    }

    public void setFlushDelay(long flushDelay) {
        if (flushDelay < 0L) {
            throw new IllegalArgumentException("flushDelay must be >= 0");
        }
        this.flushDelay = flushDelay;
    }

    public void setConnectionRecoveryDelay(long connectionRecoveryDelay) {
        if (connectionRecoveryDelay < 0L) {
            throw new IllegalArgumentException("connectionRecoveryDelay must be >= 0");
        }
        this.connectionRecoveryDelay = connectionRecoveryDelay;
    }

    public void setUpdateDelay(long updateDelay) {
        this.updateDelay = updateDelay;
    }

    public void setNodeServiceIncrementSql(String sql) {
        if (((String)ObjectUtils.requireNonNullArgument((Object)sql, (String)"sql")).equals(this.nodeServiceIncrementSql)) {
            return;
        }
        this.nodeServiceIncrementSql = sql;
        this.reconnectWriter();
    }

    public void setStatLogUpdateCount(int statLogUpdateCount) {
        this.statCounter.setLogFrequency(statLogUpdateCount);
    }

    private class WriterThread
    extends Thread {
        private final AtomicBoolean keepGoingWithConnection = new AtomicBoolean(true);
        private final AtomicBoolean keepGoing = new AtomicBoolean(true);
        private boolean started = false;

        private WriterThread() {
        }

        public boolean hasStarted() {
            return this.started;
        }

        public boolean isGoing() {
            return this.keepGoing.get();
        }

        public void reconnect() {
            this.keepGoingWithConnection.compareAndSet(true, false);
        }

        public void exit() {
            this.keepGoing.compareAndSet(true, false);
            this.keepGoingWithConnection.compareAndSet(true, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            JdbcNodeServiceAuditor.this.log.info("Started JDBC audit writer thread {}", (Object)this);
            JdbcNodeServiceAuditor.this.statCounter.increment((Enum)JdbcNodeServiceAuditorCount.WriterThreadsStarted);
            try {
                while (this.keepGoing.get()) {
                    this.keepGoingWithConnection.set(true);
                    WriterThread writerThread = this;
                    synchronized (writerThread) {
                        this.started = true;
                        this.notifyAll();
                    }
                    try {
                        this.keepGoing.compareAndSet(true, this.execute());
                    }
                    catch (RuntimeException | SQLException e) {
                        JdbcNodeServiceAuditor.this.log.warn("Exception with auditing", (Throwable)e);
                        try {
                            Thread.sleep(JdbcNodeServiceAuditor.this.connectionRecoveryDelay);
                        }
                        catch (InterruptedException e2) {
                            JdbcNodeServiceAuditor.this.log.info("Audit writer thread interrupted: exiting now.");
                            this.keepGoing.set(false);
                        }
                    }
                }
                return;
            }
            finally {
                JdbcNodeServiceAuditor.this.statCounter.increment((Enum)JdbcNodeServiceAuditorCount.WriterThreadsEnded);
            }
        }

        private Boolean execute() throws SQLException {
            Connection conn = JdbcNodeServiceAuditor.this.dataSource.getConnection();
            try {
                JdbcNodeServiceAuditor.this.statCounter.increment((Enum)JdbcNodeServiceAuditorCount.ConnectionsCreated);
                conn.setAutoCommit(true);
                PreparedStatement stmt = JdbcNodeServiceAuditor.this.isCallableStatement(JdbcNodeServiceAuditor.this.nodeServiceIncrementSql) ? conn.prepareCall(JdbcNodeServiceAuditor.this.nodeServiceIncrementSql) : conn.prepareStatement(JdbcNodeServiceAuditor.this.nodeServiceIncrementSql);
                do {
                    try {
                        if (Thread.interrupted()) {
                            throw new InterruptedException();
                        }
                        JdbcNodeServiceAuditor.this.flushNodeServiceData(stmt);
                        Thread.sleep(JdbcNodeServiceAuditor.this.flushDelay);
                    }
                    catch (InterruptedException e) {
                        JdbcNodeServiceAuditor.this.log.info("Writer thread interrupted: exiting now.");
                        Boolean bl = false;
                        if (conn != null) {
                            conn.close();
                        }
                        return bl;
                    }
                } while (this.keepGoingWithConnection.get());
                Boolean bl = true;
                return bl;
            }
            finally {
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2;
                        throwable2.addSuppressed(throwable);
                    }
                }
            }
        }
    }
}

