/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.central.common.dao.jdbc;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.solarnetwork.central.common.dao.LocationRequestCriteria;
import net.solarnetwork.central.common.dao.LocationRequestDao;
import net.solarnetwork.central.common.dao.jdbc.LocationRequestRowMapper;
import net.solarnetwork.central.common.dao.jdbc.sql.DeleteLocationRequest;
import net.solarnetwork.central.common.dao.jdbc.sql.InsertLocationRequest;
import net.solarnetwork.central.common.dao.jdbc.sql.SelectLocationRequest;
import net.solarnetwork.central.common.dao.jdbc.sql.UpdateLocationRequest;
import net.solarnetwork.central.domain.LocationRequest;
import net.solarnetwork.dao.BasicFilterResults;
import net.solarnetwork.dao.FilterResults;
import net.solarnetwork.domain.SortDescriptor;
import net.solarnetwork.util.ObjectUtils;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;

public class JdbcLocationRequestDao
implements LocationRequestDao {
    private final JdbcOperations jdbcOps;

    public JdbcLocationRequestDao(JdbcOperations jdbcOps) {
        this.jdbcOps = (JdbcOperations)ObjectUtils.requireNonNullArgument((Object)jdbcOps, (String)"jdbcOps");
    }

    public FilterResults<LocationRequest, Long> findFiltered(LocationRequestCriteria filter, List<SortDescriptor> sorts, Integer offset, Integer max) {
        SelectLocationRequest sql = new SelectLocationRequest(filter);
        List list = this.jdbcOps.query((PreparedStatementCreator)sql, LocationRequestRowMapper.INSTANCE);
        return BasicFilterResults.filterResults((Iterable)list, null, (Long)Long.valueOf(list.size()), (int)list.size());
    }

    public Class<? extends LocationRequest> getObjectType() {
        return LocationRequest.class;
    }

    public Long save(LocationRequest entity) {
        Long result = null;
        if (entity.getId() == null) {
            InsertLocationRequest sql = new InsertLocationRequest(entity);
            GeneratedKeyHolder keyHolder = new GeneratedKeyHolder();
            this.jdbcOps.update((PreparedStatementCreator)sql, (KeyHolder)keyHolder);
            Map keys = keyHolder.getKeys();
            Object id = keys.get("id");
            result = id instanceof Long ? (Long)id : null;
        } else {
            UpdateLocationRequest sql = new UpdateLocationRequest(entity);
            int count = this.jdbcOps.update((PreparedStatementCreator)sql);
            result = count > 0 ? (Long)entity.getId() : null;
        }
        return result;
    }

    public LocationRequest get(Long id) {
        SelectLocationRequest sql = new SelectLocationRequest(id);
        List list = this.jdbcOps.query((PreparedStatementCreator)sql, LocationRequestRowMapper.INSTANCE);
        return list != null && !list.isEmpty() ? (LocationRequest)((Object)list.get(0)) : null;
    }

    public Collection<LocationRequest> getAll(List<SortDescriptor> sorts) {
        throw new UnsupportedOperationException();
    }

    public void delete(LocationRequest entity) {
        this.jdbcOps.update((PreparedStatementCreator)new DeleteLocationRequest((Long)((LocationRequest)((Object)ObjectUtils.requireNonNullArgument((Object)((Object)entity), (String)"entity"))).getId()));
    }

    @Override
    public List<LocationRequest> find(Long id, LocationRequestCriteria filter) {
        return this.jdbcOps.query((PreparedStatementCreator)new SelectLocationRequest(id, filter), LocationRequestRowMapper.INSTANCE);
    }

    @Override
    public int delete(Long id, LocationRequestCriteria filter) {
        return this.jdbcOps.update((PreparedStatementCreator)new DeleteLocationRequest(id, filter));
    }
}

