/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.central.common.dao.jdbc;

import java.util.Collection;
import java.util.List;
import net.solarnetwork.central.common.dao.jdbc.AppSettingRowMapper;
import net.solarnetwork.central.common.dao.jdbc.sql.DeleteAppSetting;
import net.solarnetwork.central.common.dao.jdbc.sql.InsertAppSetting;
import net.solarnetwork.central.common.dao.jdbc.sql.SelectAppSetting;
import net.solarnetwork.central.dao.AppSettingDao;
import net.solarnetwork.central.domain.AppSetting;
import net.solarnetwork.central.domain.KeyTypePK;
import net.solarnetwork.domain.SortDescriptor;
import net.solarnetwork.util.ObjectUtils;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.PreparedStatementCreator;

public class JdbcAppSettingDao
implements AppSettingDao {
    private final JdbcOperations jdbcOps;

    public JdbcAppSettingDao(JdbcOperations jdbcOps) {
        this.jdbcOps = (JdbcOperations)ObjectUtils.requireNonNullArgument((Object)jdbcOps, (String)"jdbcOps");
    }

    public Class<? extends AppSetting> getObjectType() {
        return AppSetting.class;
    }

    public KeyTypePK save(AppSetting entity) {
        ObjectUtils.requireNonNullArgument((Object)entity, (String)"entity");
        this.jdbcOps.update((PreparedStatementCreator)new InsertAppSetting(entity, true));
        return (KeyTypePK)entity.getId();
    }

    public AppSetting get(KeyTypePK id) {
        ObjectUtils.requireNonNullArgument((Object)id, (String)"id");
        List result = this.jdbcOps.query((PreparedStatementCreator)SelectAppSetting.selectForKeyType(id.getKey(), id.getType()), AppSettingRowMapper.INSTANCE);
        return !result.isEmpty() ? (AppSetting)result.get(0) : null;
    }

    public Collection<AppSetting> getAll(List<SortDescriptor> sorts) {
        throw new UnsupportedOperationException();
    }

    public void delete(AppSetting entity) {
        ObjectUtils.requireNonNullArgument((Object)entity, (String)"entity");
        this.jdbcOps.update((PreparedStatementCreator)DeleteAppSetting.deleteForKeyType(entity.getKey(), entity.getType()));
    }

    @Override
    public int deleteAll(String key) {
        ObjectUtils.requireNonNullArgument((Object)key, (String)"key");
        return this.jdbcOps.update((PreparedStatementCreator)DeleteAppSetting.deleteForKey(key));
    }

    @Override
    public AppSetting lockForUpdate(String key, String type) {
        List result = this.jdbcOps.query((PreparedStatementCreator)SelectAppSetting.selectForKeyType(key, type, true), AppSettingRowMapper.INSTANCE);
        return !result.isEmpty() ? (AppSetting)result.get(0) : null;
    }

    @Override
    public Collection<AppSetting> lockForUpdate(String key) {
        return this.jdbcOps.query((PreparedStatementCreator)SelectAppSetting.selectForKey(key, true), AppSettingRowMapper.INSTANCE);
    }
}

