/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.central.common.dao.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.DateTimeException;
import java.time.ZoneId;
import java.time.ZoneOffset;
import net.solarnetwork.central.domain.BasicSolarNodeOwnership;
import net.solarnetwork.central.domain.SolarNodeOwnership;
import org.springframework.jdbc.core.RowMapper;

public class BasicSolarNodeOwnershipRowMapper
implements RowMapper<SolarNodeOwnership> {
    public static final RowMapper<SolarNodeOwnership> INSTANCE = new BasicSolarNodeOwnershipRowMapper();

    public SolarNodeOwnership mapRow(ResultSet rs, int rowNum) throws SQLException {
        int colCount = rs.getMetaData().getColumnCount();
        Long nodeId = (Long)rs.getObject(1);
        Long userId = (Long)rs.getObject(2);
        String country = null;
        if (colCount >= 3) {
            country = rs.getString(3);
        }
        ZoneId zone = ZoneOffset.UTC;
        if (colCount >= 4) {
            try {
                zone = ZoneId.of(rs.getString(4));
            }
            catch (DateTimeException dateTimeException) {
                // empty catch block
            }
        }
        boolean priv = false;
        if (colCount >= 5) {
            priv = rs.getBoolean(5);
        }
        boolean arch = false;
        if (colCount >= 6) {
            arch = rs.getBoolean(6);
        }
        return new BasicSolarNodeOwnership(nodeId, userId, country, zone, priv, arch);
    }
}

