/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.central.common.dao;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.function.Predicate;
import javax.cache.Cache;
import net.solarnetwork.dao.Entity;
import net.solarnetwork.dao.GenericDao;
import net.solarnetwork.domain.SortDescriptor;
import net.solarnetwork.util.ObjectUtils;

public class CachingGenericDao<T extends Entity<K>, K, D extends GenericDao<T, K>>
implements GenericDao<T, K> {
    protected final D delegate;
    protected final Cache<K, T> cache;
    protected final Executor executor;

    public CachingGenericDao(D delegate, Cache<K, T> cache, Executor executor) {
        this.delegate = (GenericDao)ObjectUtils.requireNonNullArgument(delegate, (String)"delegate");
        this.cache = (Cache)ObjectUtils.requireNonNullArgument(cache, (String)"cache");
        this.executor = (Executor)ObjectUtils.requireNonNullArgument((Object)executor, (String)"executor");
    }

    public String entityEventTopic(GenericDao.EntityEventType eventType) {
        return this.delegate.entityEventTopic(eventType);
    }

    public Class<? extends T> getObjectType() {
        return this.delegate.getObjectType();
    }

    public K save(T entity) {
        Object result = this.delegate.save(entity);
        if (result != null) {
            this.cache.remove(result);
        }
        return (K)result;
    }

    public T get(K id) {
        Entity result = (Entity)this.cache.get(id);
        if (result == null && (result = this.delegate.get(id)) != null) {
            this.cache.put(id, (Object)result);
        }
        return (T)result;
    }

    public Collection<T> getAll(List<SortDescriptor> sorts) {
        return this.delegate.getAll(sorts);
    }

    public void delete(T entity) {
        this.delegate.delete(entity);
        if (entity.getId() != null) {
            this.cache.remove(entity.getId());
        }
    }

    protected void evictKeysMatching(Predicate<K> filter) {
        this.executor.execute(() -> {
            Iterator itr = this.cache.iterator();
            while (itr.hasNext()) {
                Cache.Entry entry = (Cache.Entry)itr.next();
                if (entry == null || !filter.test(entry.getKey())) continue;
                itr.remove();
            }
        });
    }
}

