/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.central.common.dao;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSetter;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.solarnetwork.central.common.dao.EnabledCriteria;
import net.solarnetwork.central.common.dao.LocationCriteria;
import net.solarnetwork.central.common.dao.NodeCriteria;
import net.solarnetwork.central.common.dao.NodeOwnershipCriteria;
import net.solarnetwork.central.common.dao.SearchFilterCriteria;
import net.solarnetwork.central.common.dao.SecurityTokenCriteria;
import net.solarnetwork.central.common.dao.SourceCriteria;
import net.solarnetwork.central.common.dao.UserCriteria;
import net.solarnetwork.central.common.dao.UserModifiableFilter;
import net.solarnetwork.dao.PaginationCriteria;
import net.solarnetwork.domain.Location;
import net.solarnetwork.domain.SimpleLocation;
import net.solarnetwork.domain.SimplePagination;
import net.solarnetwork.domain.SimpleSortDescriptor;
import net.solarnetwork.domain.SortDescriptor;

public class BasicCoreCriteria
extends SimplePagination
implements UserModifiableFilter,
PaginationCriteria,
LocationCriteria,
NodeCriteria,
SourceCriteria,
UserCriteria,
SecurityTokenCriteria,
SearchFilterCriteria,
EnabledCriteria,
NodeOwnershipCriteria {
    private Long[] locationIds;
    private Long[] nodeIds;
    private String[] sourceIds;
    private Long[] userIds;
    private String[] tokenIds;
    private SimpleLocation location;
    private String searchFilter;
    private Boolean enabled;
    private Boolean validNodeOwnership;

    public BasicCoreCriteria() {
    }

    public BasicCoreCriteria(PaginationCriteria criteria) {
        this.copyFrom(criteria);
    }

    public BasicCoreCriteria clone() {
        BasicCoreCriteria result = (BasicCoreCriteria)super.clone();
        if (this.location != null) {
            result.location = this.location.clone();
        }
        return result;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Arrays.hashCode((Object[])this.locationIds);
        result = 31 * result + Arrays.hashCode((Object[])this.nodeIds);
        result = 31 * result + Arrays.hashCode(this.sourceIds);
        result = 31 * result + Arrays.hashCode(this.tokenIds);
        result = 31 * result + Arrays.hashCode((Object[])this.userIds);
        result = 31 * result + Objects.hashCode(this.location);
        result = 31 * result + Objects.hashCode(this.searchFilter);
        result = 31 * result + Objects.hashCode(this.enabled);
        result = 31 * result + Objects.hashCode(this.validNodeOwnership);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof BasicCoreCriteria)) {
            return false;
        }
        BasicCoreCriteria other = (BasicCoreCriteria)obj;
        return Arrays.equals((Object[])this.locationIds, (Object[])other.locationIds) && Arrays.equals((Object[])this.nodeIds, (Object[])other.nodeIds) && Arrays.equals(this.sourceIds, other.sourceIds) && Arrays.equals(this.tokenIds, other.tokenIds) && Arrays.equals((Object[])this.userIds, (Object[])other.userIds) && Objects.equals(this.location, other.location) && Objects.equals(this.searchFilter, other.searchFilter) && Objects.equals(this.enabled, other.enabled) && Objects.equals(this.validNodeOwnership, other.validNodeOwnership);
    }

    public void copyFrom(PaginationCriteria criteria) {
        if (criteria == null) {
            return;
        }
        this.setMax(criteria.getMax());
        this.setOffset(criteria.getOffset());
        this.setSorts(criteria.getSorts());
        if (criteria instanceof BasicCoreCriteria) {
            BasicCoreCriteria c = (BasicCoreCriteria)criteria;
            this.setLocationIds(c.getLocationIds());
            this.setLocation(c.getLocation());
            this.setNodeIds(c.getNodeIds());
            this.setSourceIds(c.getSourceIds());
            this.setUserIds(c.getUserIds());
            this.setTokenIds(c.getTokenIds());
            this.setSearchFilter(c.getSearchFilter());
            this.setEnabled(c.getEnabled());
            this.setValidNodeOwnership(c.getValidNodeOwnership());
        } else {
            Object c;
            if (criteria instanceof LocationCriteria) {
                c = (LocationCriteria)criteria;
                this.setLocationIds(c.getLocationIds());
                this.setLocation(SimpleLocation.locationValue((Location)c.getLocation()));
            }
            if (criteria instanceof NodeCriteria) {
                c = (NodeCriteria)criteria;
                this.setNodeIds(c.getNodeIds());
            }
            if (criteria instanceof SourceCriteria) {
                c = (SourceCriteria)criteria;
                this.setSourceIds(c.getSourceIds());
            }
            if (criteria instanceof UserCriteria) {
                c = (UserCriteria)criteria;
                this.setUserIds(c.getUserIds());
            }
            if (criteria instanceof SecurityTokenCriteria) {
                c = (SecurityTokenCriteria)criteria;
                this.setTokenIds(c.getTokenIds());
            }
            if (criteria instanceof SearchFilterCriteria) {
                c = (SearchFilterCriteria)criteria;
                this.setSearchFilter(c.getSearchFilter());
            }
            if (criteria instanceof EnabledCriteria) {
                c = (EnabledCriteria)criteria;
                this.setEnabled(c.getEnabled());
            }
            if (criteria instanceof NodeOwnershipCriteria) {
                c = (NodeOwnershipCriteria)criteria;
                this.setValidNodeOwnership(c.getValidNodeOwnership());
            }
        }
    }

    @JsonSetter
    public void setLocationId(Long locationId) {
        Long[] longArray;
        if (locationId == null) {
            longArray = null;
        } else {
            Long[] longArray2 = new Long[1];
            longArray = longArray2;
            longArray2[0] = locationId;
        }
        this.setLocationIds(longArray);
    }

    @Override
    @JsonIgnore
    public Long getLocationId() {
        return this.locationIds != null && this.locationIds.length > 0 ? this.locationIds[0] : null;
    }

    @Override
    public Long[] getLocationIds() {
        return this.locationIds;
    }

    public void setLocationIds(Long[] locationIds) {
        this.locationIds = locationIds;
    }

    @JsonSetter
    public void setNodeId(Long nodeId) {
        Long[] longArray;
        if (nodeId == null) {
            longArray = null;
        } else {
            Long[] longArray2 = new Long[1];
            longArray = longArray2;
            longArray2[0] = nodeId;
        }
        this.setNodeIds(longArray);
    }

    @Override
    @JsonIgnore
    public Long getNodeId() {
        return this.nodeIds == null || this.nodeIds.length < 1 ? null : this.nodeIds[0];
    }

    @Override
    public Long[] getNodeIds() {
        return this.nodeIds;
    }

    public void setNodeIds(Long[] nodeIds) {
        this.nodeIds = nodeIds;
    }

    @JsonSetter
    public void setSourceId(String sourceId) {
        String[] stringArray;
        if (sourceId == null) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = sourceId;
        }
        this.setSourceIds(stringArray);
    }

    @Override
    @JsonIgnore
    public String getSourceId() {
        return this.sourceIds == null || this.sourceIds.length < 1 ? null : this.sourceIds[0];
    }

    @Override
    public String[] getSourceIds() {
        return this.sourceIds;
    }

    public void setSourceIds(String[] sourceIds) {
        this.sourceIds = sourceIds;
    }

    @JsonSetter
    public void setUserId(Long userId) {
        Long[] longArray;
        if (userId == null) {
            longArray = null;
        } else {
            Long[] longArray2 = new Long[1];
            longArray = longArray2;
            longArray2[0] = userId;
        }
        this.userIds = longArray;
    }

    @Override
    @JsonIgnore
    public Long getUserId() {
        return this.userIds == null || this.userIds.length < 1 ? null : this.userIds[0];
    }

    @Override
    public Long[] getUserIds() {
        return this.userIds;
    }

    public void setUserIds(Long[] userIds) {
        this.userIds = userIds;
    }

    @JsonSetter
    public void setTokenId(String tokenId) {
        String[] stringArray;
        if (tokenId == null) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = tokenId.trim();
        }
        this.setTokenIds(stringArray);
    }

    @Override
    @JsonIgnore
    public String getTokenId() {
        return this.tokenIds == null || this.tokenIds.length < 1 ? null : this.tokenIds[0];
    }

    @Override
    public String[] getTokenIds() {
        return this.tokenIds;
    }

    public void setTokenIds(String[] tokenIds) {
        this.tokenIds = tokenIds;
    }

    public SimpleLocation getLocation() {
        return this.location;
    }

    public void setLocation(SimpleLocation location) {
        this.location = location;
    }

    @Override
    public String getSearchFilter() {
        return this.searchFilter;
    }

    public void setSearchFilter(String searchFilter) {
        this.searchFilter = searchFilter;
    }

    public List<String> getOrderBy() {
        List sorts = this.getSorts();
        if (sorts == null || sorts.isEmpty()) {
            return null;
        }
        return sorts.stream().map(s -> s.isDescending() ? s.getSortKey().concat("~") : s.getSortKey()).toList();
    }

    public void setOrderBy(List<String> orderBys) {
        if (orderBys == null || orderBys.isEmpty()) {
            this.setSorts(null);
        }
        List<SortDescriptor> sorts = orderBys.stream().map(o -> {
            boolean desc = o.endsWith("~");
            return new SimpleSortDescriptor(desc ? o.substring(0, o.length() - 1) : o, desc);
        }).toList();
        this.setSorts(sorts);
    }

    @Override
    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public Boolean getValidNodeOwnership() {
        return this.validNodeOwnership;
    }

    public void setValidNodeOwnership(Boolean validNodeOwnership) {
        this.validNodeOwnership = validNodeOwnership;
    }
}

