/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.central.common.config;

import java.util.LinkedHashMap;
import java.util.Map;
import net.solarnetwork.central.biz.AppConfigurationBiz;
import net.solarnetwork.central.biz.BasicNetworkIdentificationBiz;
import net.solarnetwork.central.biz.NetworkIdentificationBiz;
import net.solarnetwork.central.support.BasicAppConfigurationBiz;
import net.solarnetwork.central.support.SimpleAppConfiguration;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

@Configuration(proxyBeanMethods=false)
public class NetworkIdentityConfig {
    @Bean
    @ConfigurationProperties(prefix="app.network-identity")
    public NetworkIdentitySettings networkIdentitySettings() {
        return new NetworkIdentitySettings();
    }

    @Bean
    public AppConfigurationBiz appConfigurationBiz(NetworkIdentitySettings settings) {
        return new BasicAppConfigurationBiz(new SimpleAppConfiguration(settings.serviceUrls));
    }

    @Bean
    public NetworkIdentificationBiz networkIdentificationBiz(NetworkIdentitySettings settings) {
        return new BasicNetworkIdentificationBiz(settings.networkIdentityKey, settings.termsOfService, settings.host, settings.port, settings.forceTls, settings.serviceUrls);
    }

    public static class NetworkIdentitySettings {
        private String networkIdentityKey = "replace:identity:here";
        private Resource termsOfService = new ClassPathResource("net/solarnetwork/central/in/config/placeholder-toc.txt");
        private String host = "localhost";
        private int port = 8080;
        private boolean forceTls = false;
        private Map<String, String> serviceUrls = NetworkIdentitySettings.defaultNetworkServiceUrls();

        private static Map<String, String> defaultNetworkServiceUrls() {
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(4);
            map.put("solaruser", "http://localhost/solaruser");
            map.put("solarquery", "http://localhost/solarquery");
            map.put("solarin-mqtt", "mqtts://localhost:8883");
            return map;
        }

        public String getNetworkIdentityKey() {
            return this.networkIdentityKey;
        }

        public void setNetworkIdentityKey(String networkIdentityKey) {
            this.networkIdentityKey = networkIdentityKey;
        }

        public Resource getTermsOfService() {
            return this.termsOfService;
        }

        public void setTermsOfService(Resource termsOfService) {
            this.termsOfService = termsOfService;
        }

        public String getHost() {
            return this.host;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public int getPort() {
            return this.port;
        }

        public void setPort(int port) {
            this.port = port;
        }

        public boolean isForceTls() {
            return this.forceTls;
        }

        public void setForceTls(boolean forceTls) {
            this.forceTls = forceTls;
        }

        public Map<String, String> getServiceUrls() {
            return this.serviceUrls;
        }

        public void setServiceUrls(Map<String, String> serviceUrls) {
            this.serviceUrls = serviceUrls;
        }
    }
}

