/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.central.common.config;

import javax.sql.DataSource;
import net.solarnetwork.central.common.dao.jdbc.JdbcNodeServiceAuditor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;

@Configuration(proxyBeanMethods=false)
@Profile(value={"node-service-auditor"})
public class JdbcNodeServiceAuditorConfig {
    public static final String AUDIT = "audit";
    @Autowired
    private DataSource dataSource;
    @Autowired(required=false)
    @Qualifier(value="audit")
    private DataSource readWriteDataSource;

    @Bean
    @ConfigurationProperties(prefix="app.node-service-auditor")
    public NodeServiceAuditorSettings nodeServiceAuditorSettings() {
        return new NodeServiceAuditorSettings();
    }

    @Bean(initMethod="serviceDidStartup", destroyMethod="serviceDidShutdown")
    public JdbcNodeServiceAuditor nodeServiceAuditor(NodeServiceAuditorSettings settings) {
        DataSource ds = this.readWriteDataSource != null ? this.readWriteDataSource : this.dataSource;
        JdbcNodeServiceAuditor auditor = new JdbcNodeServiceAuditor(ds);
        auditor.setUpdateDelay(settings.updateDelay);
        auditor.setFlushDelay(settings.flushDelay);
        auditor.setConnectionRecoveryDelay(settings.connectionRecoveryDelay);
        auditor.setStatLogUpdateCount(settings.statLogUpdateCount);
        return auditor;
    }

    public static class NodeServiceAuditorSettings {
        private long updateDelay = 100L;
        private long flushDelay = 10000L;
        private long connectionRecoveryDelay = 15000L;
        private int statLogUpdateCount = 1000;

        public long getUpdateDelay() {
            return this.updateDelay;
        }

        public void setUpdateDelay(long updateDelay) {
            this.updateDelay = updateDelay;
        }

        public long getFlushDelay() {
            return this.flushDelay;
        }

        public void setFlushDelay(long flushDelay) {
            this.flushDelay = flushDelay;
        }

        public long getConnectionRecoveryDelay() {
            return this.connectionRecoveryDelay;
        }

        public void setConnectionRecoveryDelay(long connectionRecoveryDelay) {
            this.connectionRecoveryDelay = connectionRecoveryDelay;
        }

        public int getStatLogUpdateCount() {
            return this.statLogUpdateCount;
        }

        public void setStatLogUpdateCount(int statLogUpdateCount) {
            this.statLogUpdateCount = statLogUpdateCount;
        }
    }
}

