/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.central.common.config;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import net.solarnetwork.central.cloud.domain.ContainerMetadata;
import net.solarnetwork.codec.JsonUtils;
import net.solarnetwork.util.ByteUtils;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.boot.logging.DeferredLog;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.util.StreamUtils;
import org.springframework.util.StringUtils;

public class ApplicationMetadataEnvironmentPostProcessor
implements EnvironmentPostProcessor,
Ordered {
    public static final String APP_PROP_PREFIX = "app.meta.";
    public static final int DEFAULT_MAX_CONTAINER_ID_LENGTH = 8;
    public static final String ENV_APP_ID_CONTAINER_ID_LENGTH = "APP_ID_CONTAINER_ID_LENGTH";
    private final DeferredLog logger = new DeferredLog();
    private int order = -2147483639;

    public void setOrder(int order) {
        this.order = order;
    }

    public int getOrder() {
        return this.order;
    }

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        ContainerMetadata meta;
        String appVersion;
        application.addInitializers(new ApplicationContextInitializer[]{ctx -> this.logger.replayTo(ApplicationMetadataEnvironmentPostProcessor.class)});
        Properties appProps = new Properties();
        String appName = environment.getProperty("application.title", "");
        if (!appName.isBlank()) {
            this.addWithPrefix(appProps, "name", appName);
        }
        if (!(appVersion = environment.getProperty("application.version", "")).isBlank()) {
            this.addWithPrefix(appProps, "version", appVersion);
        }
        String appInstanceId = null;
        Map sysEnv = environment.getSystemEnvironment();
        Object ecsMetaUri = sysEnv.get("ECS_CONTAINER_METADATA_URI_V4");
        if (ecsMetaUri != null && (meta = this.ecsContainerMetadataV4(String.valueOf(ecsMetaUri) + "/task")) != null) {
            int maxLength;
            appInstanceId = meta.getContainerId();
            Object maxLengthProp = sysEnv.get(ENV_APP_ID_CONTAINER_ID_LENGTH);
            int n = maxLength = maxLengthProp != null ? Integer.parseInt(maxLengthProp.toString()) : 8;
            if (maxLength > 0 && appInstanceId.length() > maxLength) {
                appInstanceId = appInstanceId.substring(0, maxLength);
            }
        }
        if (appInstanceId == null) {
            Object hostname = sysEnv.get("HOSTNAME");
            if (hostname != null && !hostname.toString().isBlank()) {
                appInstanceId = hostname.toString();
            } else {
                hostname = this.exec(new String[]{"hostname"});
                if (hostname != null && !hostname.toString().isBlank()) {
                    appInstanceId = hostname.toString();
                }
            }
        }
        this.addWithPrefix(appProps, "instance-id", appInstanceId != null ? appInstanceId : UUID.randomUUID().toString());
        this.logger.info((Object)("Environment app metadata: " + String.valueOf(appProps)));
        MutablePropertySources propertySources = environment.getPropertySources();
        if (propertySources.contains("commandLineArgs")) {
            propertySources.addAfter("commandLineArgs", (PropertySource)new PropertiesPropertySource("solarnet", appProps));
        } else {
            propertySources.addFirst((PropertySource)new PropertiesPropertySource("solarnet", appProps));
        }
    }

    private void addWithPrefix(Properties props, String key, Object value) {
        props.put(APP_PROP_PREFIX + key, value);
    }

    private String exec(String[] command) {
        String string;
        block8: {
            InputStream in = Runtime.getRuntime().exec(command).getInputStream();
            try {
                string = StreamUtils.copyToString((InputStream)in, (Charset)ByteUtils.UTF8).trim();
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    this.logger.warn((Object)String.format("Error executing [%s]", StringUtils.arrayToDelimitedString((Object[])command, (String)" ")), (Throwable)e);
                    return null;
                }
            }
            in.close();
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ContainerMetadata ecsContainerMetadataV4(String uri) {
        ObjectMapper mapper = JsonUtils.newObjectMapper();
        try (JsonParser p = mapper.createParser(new URI(uri).toURL());){
            ObjectNode root = (ObjectNode)p.readValueAsTree();
            JsonNode taskArn = root.get("TaskARN");
            if (taskArn == null) {
                this.logger.error((Object)String.format("TaskARN not available in ECS container metadata from [%s]: %s", uri, root));
                ContainerMetadata containerMetadata = null;
                return containerMetadata;
            }
            String taskId = taskArn.textValue();
            if (taskId == null || taskId.isBlank()) {
                this.logger.error((Object)String.format("TaskARN empty in ECS container metadata from [%s]: %s", uri, root));
                ContainerMetadata containerMetadata = null;
                return containerMetadata;
            }
            int slashIdx = taskId.lastIndexOf(47);
            if (slashIdx >= 0 && slashIdx + 1 < taskId.length()) {
                taskId = taskId.substring(slashIdx + 1);
            }
            ContainerMetadata meta = new ContainerMetadata(taskId);
            this.logger.info((Object)String.format("Discovered ECS metadata from [%s]: %s", uri, root));
            ContainerMetadata containerMetadata = meta;
            return containerMetadata;
        }
        catch (URISyntaxException e) {
            this.logger.error((Object)String.format("URL syntax error for ECS container metadata from [%s]: %s", uri, e.toString()));
            return null;
        }
        catch (IOException e) {
            this.logger.error((Object)String.format("IO error reading ECS container metadata from [%s]: %s", uri, e.toString()));
        }
        return null;
    }
}

