/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.central.cloud.aws.domain;

import java.util.List;
import net.solarnetwork.central.cloud.domain.VirtualMachine;
import net.solarnetwork.central.cloud.domain.VirtualMachineState;
import net.solarnetwork.central.dao.BaseObjectEntity;
import software.amazon.awssdk.services.ec2.model.Instance;
import software.amazon.awssdk.services.ec2.model.InstanceState;

public class Ec2VirtualMachine
extends BaseObjectEntity<String>
implements VirtualMachine {
    private static final long serialVersionUID = -4700896078284783343L;
    private final String displayName;
    private VirtualMachineState state = VirtualMachineState.Unknown;

    public Ec2VirtualMachine(String instanceId, String displayName) {
        this.setId(instanceId);
        this.displayName = displayName;
    }

    public Ec2VirtualMachine(Instance instance) {
        this(instance.instanceId(), Ec2VirtualMachine.displayNameForInstance(instance));
        this.state = Ec2VirtualMachine.virtualMachineStateForInstanceState(instance.state());
    }

    public static final String displayNameForInstance(Instance instance) {
        List tags = instance.tags();
        if (tags == null) {
            return instance.instanceId();
        }
        return instance.tags().stream().filter(t -> "name".equalsIgnoreCase(t.key())).findFirst().map(t -> t.value()).orElse(instance.instanceId());
    }

    public static final VirtualMachineState virtualMachineStateForInstanceState(InstanceState state) {
        if (state == null) {
            return VirtualMachineState.Unknown;
        }
        byte s = (byte)(state.code() & 0xFF);
        switch (s) {
            case 0: {
                return VirtualMachineState.Starting;
            }
            case 16: {
                return VirtualMachineState.Running;
            }
            case 32: 
            case 64: {
                return VirtualMachineState.Stopping;
            }
            case 48: {
                return VirtualMachineState.Terminated;
            }
            case 80: {
                return VirtualMachineState.Stopped;
            }
        }
        return VirtualMachineState.Unknown;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public VirtualMachineState getState() {
        return this.state;
    }

    public void setState(VirtualMachineState state) {
        this.state = state;
    }
}

