/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.central.cloud.aws.biz;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.solarnetwork.central.cloud.aws.domain.Ec2VirtualMachine;
import net.solarnetwork.central.cloud.biz.VirtualMachineBiz;
import net.solarnetwork.central.cloud.domain.VirtualMachine;
import net.solarnetwork.central.cloud.domain.VirtualMachineState;
import net.solarnetwork.service.support.BasicIdentifiable;
import net.solarnetwork.util.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.Ec2ClientBuilder;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceStatusRequest;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceStatusResponse;
import software.amazon.awssdk.services.ec2.model.DescribeInstancesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeInstancesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeTagsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeTagsResponse;
import software.amazon.awssdk.services.ec2.model.Filter;
import software.amazon.awssdk.services.ec2.model.Instance;
import software.amazon.awssdk.services.ec2.model.InstanceStatus;
import software.amazon.awssdk.services.ec2.model.Reservation;
import software.amazon.awssdk.services.ec2.model.StartInstancesRequest;
import software.amazon.awssdk.services.ec2.model.StartInstancesResponse;
import software.amazon.awssdk.services.ec2.model.StopInstancesRequest;
import software.amazon.awssdk.services.ec2.model.StopInstancesResponse;
import software.amazon.awssdk.services.ec2.model.TagDescription;

public class AwsVirtualMachineBiz
extends BasicIdentifiable
implements VirtualMachineBiz {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Ec2Client client;

    public AwsVirtualMachineBiz(String region, String accessKey, String accessKeySecret) {
        this(Region.of((String)region), (AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)AwsBasicCredentials.create((String)accessKey, (String)accessKeySecret)));
    }

    public AwsVirtualMachineBiz(Region region, AwsCredentialsProvider credentialsProvider) {
        this.setUid(UUID.randomUUID().toString());
        this.client = (Ec2Client)((Ec2ClientBuilder)((Ec2ClientBuilder)Ec2Client.builder().region((Region)ObjectUtils.requireNonNullArgument((Object)region, (String)"region"))).credentialsProvider((AwsCredentialsProvider)ObjectUtils.requireNonNullArgument((Object)credentialsProvider, (String)"credentialsProvider"))).build();
    }

    @Override
    public VirtualMachine virtualMachineForName(String name) {
        DescribeTagsRequest tagReq = (DescribeTagsRequest)DescribeTagsRequest.builder().filters(new Filter[]{(Filter)Filter.builder().name("key").values(new String[]{"Name"}).build(), (Filter)Filter.builder().name("resource-type").values(new String[]{"instance"}).build()}).build();
        while (true) {
            DescribeTagsResponse tagRes = this.client.describeTags(tagReq);
            for (TagDescription tag : tagRes.tags()) {
                if (!name.equalsIgnoreCase(tag.value())) continue;
                String instanceId = tag.resourceId();
                return new Ec2VirtualMachine(instanceId, tag.value());
            }
            if (tagReq.nextToken() == null) break;
            tagReq = (DescribeTagsRequest)tagReq.toBuilder().nextToken(tagRes.nextToken()).build();
        }
        return null;
    }

    @Override
    public Iterable<VirtualMachine> virtualMachinesForIds(Set<String> ids) {
        DescribeInstancesRequest req = (DescribeInstancesRequest)DescribeInstancesRequest.builder().instanceIds(ids).build();
        ArrayList<VirtualMachine> results = new ArrayList<VirtualMachine>(ids.size());
        while (true) {
            DescribeInstancesResponse res = this.client.describeInstances(req);
            for (Reservation reservation : res.reservations()) {
                for (Instance inst : reservation.instances()) {
                    results.add(new Ec2VirtualMachine(inst));
                }
            }
            if (res.nextToken() == null) break;
            req = (DescribeInstancesRequest)req.toBuilder().nextToken(res.nextToken()).build();
        }
        return results;
    }

    @Override
    public Map<String, VirtualMachineState> stateForVirtualMachines(Set<String> machineIds) {
        DescribeInstanceStatusRequest req = (DescribeInstanceStatusRequest)DescribeInstanceStatusRequest.builder().instanceIds(machineIds).includeAllInstances(Boolean.valueOf(true)).build();
        LinkedHashMap<String, VirtualMachineState> result = new LinkedHashMap<String, VirtualMachineState>(machineIds.size());
        while (true) {
            DescribeInstanceStatusResponse res = this.client.describeInstanceStatus(req);
            for (InstanceStatus status : res.instanceStatuses()) {
                result.put(status.instanceId(), Ec2VirtualMachine.virtualMachineStateForInstanceState(status.instanceState()));
            }
            if (res.nextToken() == null) break;
            req = (DescribeInstanceStatusRequest)req.toBuilder().nextToken(res.nextToken()).build();
        }
        return result;
    }

    @Override
    public void changeVirtualMachinesState(Set<String> machineIds, VirtualMachineState desiredState) {
        List results = null;
        if (desiredState == VirtualMachineState.Running) {
            StartInstancesRequest req = (StartInstancesRequest)StartInstancesRequest.builder().instanceIds(machineIds).build();
            StartInstancesResponse res = this.client.startInstances(req);
            results = res.startingInstances();
        } else if (desiredState == VirtualMachineState.Stopped) {
            StopInstancesRequest req = (StopInstancesRequest)StopInstancesRequest.builder().instanceIds(machineIds).build();
            StopInstancesResponse res = this.client.stopInstances(req);
            results = res.stoppingInstances();
        } else {
            throw new IllegalArgumentException("Desired state not supported: " + String.valueOf((Object)desiredState));
        }
        this.log.info("Changed EC2 instances {} desired state to {}: {}", new Object[]{machineIds, desiredState, results});
    }
}

