/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.central.cloud.aws.biz;

import javax.cache.Cache;
import net.solarnetwork.central.RemoteServiceException;
import net.solarnetwork.central.biz.SecretsBiz;
import net.solarnetwork.util.ObjectUtils;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClient;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClientBuilder;
import software.amazon.awssdk.services.secretsmanager.model.CreateSecretRequest;
import software.amazon.awssdk.services.secretsmanager.model.DeleteSecretRequest;
import software.amazon.awssdk.services.secretsmanager.model.GetSecretValueRequest;
import software.amazon.awssdk.services.secretsmanager.model.GetSecretValueResponse;
import software.amazon.awssdk.services.secretsmanager.model.InvalidRequestException;
import software.amazon.awssdk.services.secretsmanager.model.PutSecretValueRequest;
import software.amazon.awssdk.services.secretsmanager.model.ResourceExistsException;
import software.amazon.awssdk.services.secretsmanager.model.ResourceNotFoundException;

public class AwsSecretsBiz
implements SecretsBiz {
    private final SecretsManagerClient client;
    private Cache<String, String> secretCache;

    public AwsSecretsBiz(String region, String accessKey, String accessKeySecret) {
        this(Region.of((String)region), (AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)AwsBasicCredentials.create((String)accessKey, (String)accessKeySecret)));
    }

    public AwsSecretsBiz(Region region, AwsCredentialsProvider credentialsProvider) {
        this.client = (SecretsManagerClient)((SecretsManagerClientBuilder)((SecretsManagerClientBuilder)SecretsManagerClient.builder().region((Region)ObjectUtils.requireNonNullArgument((Object)region, (String)"region"))).credentialsProvider((AwsCredentialsProvider)ObjectUtils.requireNonNullArgument((Object)credentialsProvider, (String)"credentialsProvider"))).build();
    }

    @Override
    public void putSecret(String secretName, String secretValue) {
        Cache<String, String> cache = this.secretCache;
        try {
            try {
                CreateSecretRequest createReq = (CreateSecretRequest)CreateSecretRequest.builder().name(secretName).secretString(secretValue).build();
                this.client.createSecret(createReq);
            }
            catch (ResourceExistsException ree) {
                PutSecretValueRequest putReq = (PutSecretValueRequest)PutSecretValueRequest.builder().secretId(secretName).secretString(secretValue).build();
                this.client.putSecretValue(putReq);
            }
            if (cache != null) {
                cache.put((Object)secretName, (Object)secretValue);
            }
        }
        catch (SdkException e) {
            throw new RemoteServiceException("Error retrieving secret [%s]".formatted(secretName), e);
        }
    }

    @Override
    public String getSecret(String secretName) {
        String result;
        Cache<String, String> cache = this.secretCache;
        if (cache != null && (result = (String)cache.get((Object)secretName)) != null) {
            return result;
        }
        try {
            GetSecretValueRequest req = (GetSecretValueRequest)GetSecretValueRequest.builder().secretId(secretName).build();
            GetSecretValueResponse res = this.client.getSecretValue(req);
            String result2 = res.secretString();
            if (cache != null) {
                cache.put((Object)secretName, (Object)result2);
            }
            return result2;
        }
        catch (SdkException e) {
            throw new RemoteServiceException("Error retrieving secret [%s]".formatted(secretName), e);
        }
    }

    @Override
    public void deleteSecret(String secretName) {
        Cache<String, String> cache = this.secretCache;
        if (cache != null) {
            cache.remove((Object)secretName);
        }
        try {
            DeleteSecretRequest req = (DeleteSecretRequest)DeleteSecretRequest.builder().secretId(secretName).build();
            this.client.deleteSecret(req);
        }
        catch (InvalidRequestException | ResourceNotFoundException req) {
        }
        catch (SdkException e) {
            throw new RemoteServiceException("Error retrieving secret [%s]".formatted(secretName), e);
        }
    }

    public void setSecretCache(Cache<String, String> secretCache) {
        this.secretCache = secretCache;
    }
}

