/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.central.biz.dao;

import java.time.Instant;
import java.util.List;
import net.solarnetwork.central.biz.UserMetadataBiz;
import net.solarnetwork.central.dao.UserMetadataDao;
import net.solarnetwork.central.domain.UserMetadataEntity;
import net.solarnetwork.central.domain.UserMetadataFilter;
import net.solarnetwork.dao.Entity;
import net.solarnetwork.dao.FilterResults;
import net.solarnetwork.domain.SortDescriptor;
import net.solarnetwork.domain.datum.DatumMetadataOperations;
import net.solarnetwork.domain.datum.GeneralDatumMetadata;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public class DaoUserMetadataBiz
implements UserMetadataBiz {
    private final UserMetadataDao userMetadataDao;

    public DaoUserMetadataBiz(UserMetadataDao userMetadataDao) {
        this.userMetadataDao = userMetadataDao;
    }

    @Override
    @Transactional(readOnly=false, propagation=Propagation.REQUIRED)
    public void addUserMetadata(Long userId, GeneralDatumMetadata meta) {
        assert (userId != null);
        assert (meta != null);
        UserMetadataEntity um = (UserMetadataEntity)this.userMetadataDao.get(userId);
        GeneralDatumMetadata newMeta = meta;
        if (um == null) {
            um = new UserMetadataEntity(userId, Instant.now());
            newMeta = meta;
        } else if (um.getMeta() != null && !um.getMeta().equals((Object)meta)) {
            newMeta = new GeneralDatumMetadata(um.getMeta());
            newMeta.merge((DatumMetadataOperations)meta, true);
        }
        if (newMeta != null && !newMeta.equals((Object)um.getMeta())) {
            um.setMeta(newMeta);
            this.userMetadataDao.save((Entity)um);
        }
    }

    @Override
    @Transactional(readOnly=false, propagation=Propagation.REQUIRED)
    public void storeUserMetadata(Long userId, GeneralDatumMetadata meta) {
        assert (userId != null);
        assert (meta != null);
        UserMetadataEntity um = (UserMetadataEntity)this.userMetadataDao.get(userId);
        if (um == null) {
            um = new UserMetadataEntity(userId, Instant.now());
            um.setMeta(meta);
        } else {
            um.setMeta(meta);
        }
        this.userMetadataDao.save((Entity)um);
    }

    @Override
    @Transactional(readOnly=false, propagation=Propagation.REQUIRED)
    public void removeUserMetadata(Long userId) {
        UserMetadataEntity meta = (UserMetadataEntity)this.userMetadataDao.get(userId);
        if (meta != null) {
            this.userMetadataDao.delete((Entity)meta);
        }
    }

    @Override
    @Transactional(readOnly=true, propagation=Propagation.SUPPORTS)
    public FilterResults<UserMetadataEntity, Long> findUserMetadata(UserMetadataFilter criteria, List<SortDescriptor> sortDescriptors, Integer offset, Integer max) {
        return this.userMetadataDao.findFiltered(criteria, sortDescriptors, offset, max);
    }
}

