/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.central.biz.dao;

import java.time.Instant;
import java.util.List;
import net.solarnetwork.central.biz.SolarNodeMetadataBiz;
import net.solarnetwork.central.dao.SolarNodeMetadataDao;
import net.solarnetwork.central.domain.FilterResults;
import net.solarnetwork.central.domain.SolarNodeMetadata;
import net.solarnetwork.central.domain.SolarNodeMetadataFilter;
import net.solarnetwork.central.domain.SolarNodeMetadataFilterMatch;
import net.solarnetwork.domain.SortDescriptor;
import net.solarnetwork.domain.datum.DatumMetadataOperations;
import net.solarnetwork.domain.datum.GeneralDatumMetadata;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public class DaoSolarNodeMetadataBiz
implements SolarNodeMetadataBiz {
    private final SolarNodeMetadataDao solarNodeMetadataDao;

    public DaoSolarNodeMetadataBiz(SolarNodeMetadataDao solarNodeMetadataDao) {
        this.solarNodeMetadataDao = solarNodeMetadataDao;
    }

    @Override
    @Transactional(readOnly=false, propagation=Propagation.REQUIRED)
    public void addSolarNodeMetadata(Long nodeId, GeneralDatumMetadata meta) {
        assert (nodeId != null);
        assert (meta != null);
        SolarNodeMetadata snm = (SolarNodeMetadata)this.solarNodeMetadataDao.get(nodeId);
        GeneralDatumMetadata newMeta = meta;
        if (snm == null) {
            snm = new SolarNodeMetadata();
            snm.setCreated(Instant.now());
            snm.setId(nodeId);
            newMeta = meta;
        } else if (snm.getMeta() != null && !snm.getMeta().equals((Object)meta)) {
            newMeta = new GeneralDatumMetadata(snm.getMeta());
            newMeta.merge((DatumMetadataOperations)meta, true);
        }
        if (newMeta != null && !newMeta.equals((Object)snm.getMeta())) {
            snm.setMeta(newMeta);
            this.solarNodeMetadataDao.store(snm);
        }
    }

    @Override
    @Transactional(readOnly=false, propagation=Propagation.REQUIRED)
    public void storeSolarNodeMetadata(Long nodeId, GeneralDatumMetadata meta) {
        assert (nodeId != null);
        assert (meta != null);
        SolarNodeMetadata snm = (SolarNodeMetadata)this.solarNodeMetadataDao.get(nodeId);
        if (snm == null) {
            snm = new SolarNodeMetadata();
            snm.setCreated(Instant.now());
            snm.setId(nodeId);
            snm.setMeta(meta);
        } else {
            snm.setMeta(meta);
        }
        this.solarNodeMetadataDao.store(snm);
    }

    @Override
    @Transactional(readOnly=false, propagation=Propagation.REQUIRED)
    public void removeSolarNodeMetadata(Long nodeId) {
        SolarNodeMetadata meta = (SolarNodeMetadata)this.solarNodeMetadataDao.get(nodeId);
        if (meta != null) {
            this.solarNodeMetadataDao.delete(meta);
        }
    }

    @Override
    @Transactional(readOnly=true, propagation=Propagation.SUPPORTS)
    public FilterResults<SolarNodeMetadataFilterMatch> findSolarNodeMetadata(SolarNodeMetadataFilter criteria, List<SortDescriptor> sortDescriptors, Integer offset, Integer max) {
        return this.solarNodeMetadataDao.findFiltered(criteria, sortDescriptors, offset, max);
    }
}

