/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.central.biz;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.HexFormat;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.solarnetwork.central.biz.SecretsBiz;
import net.solarnetwork.codec.JsonUtils;
import net.solarnetwork.util.ObjectUtils;
import org.springframework.security.crypto.encrypt.AesBytesEncryptor;
import org.springframework.security.crypto.keygen.BytesKeyGenerator;
import org.springframework.security.crypto.keygen.KeyGenerators;

public class SimpleSecretsBiz
implements SecretsBiz {
    private static final String SECRETS_META = "secrets.meta";
    private static final String SECRETS_DATA = "secrets.data";
    private final Path dir;
    private final ConcurrentMap<String, String> data;
    private final String salt;
    private final BytesKeyGenerator iv;
    private final String password;

    public SimpleSecretsBiz(Path dir, String password) {
        this.dir = (Path)ObjectUtils.requireNonNullArgument((Object)dir, (String)"dir");
        this.data = new ConcurrentHashMap<String, String>(8, 0.9f, 2);
        this.password = password;
        Path metaPath = dir.resolve(SECRETS_META);
        if (Files.exists(metaPath, new LinkOption[0])) {
            try {
                Map meta = JsonUtils.getStringMap((String)Files.readString(metaPath));
                this.salt = (String)meta.get("salt");
                String ivString = (String)meta.get("iv");
                if (this.salt == null || ivString == null) {
                    throw new RuntimeException("Missing metadata in [%s]".formatted(metaPath));
                }
                final byte[] ivData = HexFormat.of().parseHex(ivString);
                this.iv = new BytesKeyGenerator(){

                    public int getKeyLength() {
                        return ivData.length;
                    }

                    public byte[] generateKey() {
                        return ivData;
                    }
                };
            }
            catch (IOException e) {
                throw new RuntimeException("Error reading secrets metadata from [%s]".formatted(metaPath), e);
            }
        }
        try {
            byte[] saltBytes = new byte[8];
            SecureRandom.getInstanceStrong().nextBytes(saltBytes);
            this.salt = HexFormat.of().formatHex(saltBytes);
            this.iv = KeyGenerators.shared((int)16);
            byte[] ivData = this.iv.generateKey();
            Map<String, String> meta = Map.of("salt", this.salt, "iv", HexFormat.of().formatHex(ivData));
            Path parent = metaPath.getParent();
            if (!Files.isDirectory(parent, new LinkOption[0])) {
                Files.createDirectories(parent, new FileAttribute[0]);
            }
            Files.writeString(metaPath, (CharSequence)JsonUtils.getJSONString(meta, (String)"{}"), new OpenOption[0]);
        }
        catch (IOException | NoSuchAlgorithmException e) {
            throw new RuntimeException("Error creating secrets metadata in [%s]".formatted(metaPath), e);
        }
        Path dataPath = dir.resolve(SECRETS_DATA);
        if (Files.isReadable(dataPath)) {
            AesBytesEncryptor encryptor = new AesBytesEncryptor(password, (CharSequence)this.salt, this.iv, AesBytesEncryptor.CipherAlgorithm.GCM);
            try {
                byte[] enc = Files.readAllBytes(dataPath);
                Map map = JsonUtils.getStringMap((String)new String(encryptor.decrypt(enc), StandardCharsets.UTF_8));
                map.forEach((k, v) -> this.data.put((String)k, v.toString()));
            }
            catch (IOException e) {
                throw new RuntimeException("Error loading encrypted secrets from [%s]".formatted(dataPath), e);
            }
        }
    }

    @Override
    public String getSecret(String secretName) {
        return (String)this.data.get(secretName);
    }

    @Override
    public synchronized void putSecret(String secretName, String secretValue) {
        this.data.put(secretName, secretValue);
        this.saveData();
    }

    @Override
    public synchronized void deleteSecret(String secretName) {
        this.data.remove(secretName);
        this.saveData();
    }

    private void saveData() {
        Path dataPath = this.dir.resolve(SECRETS_DATA);
        try {
            String json = JsonUtils.getJSONString(this.data, (String)"{}");
            AesBytesEncryptor encryptor = new AesBytesEncryptor(this.password, (CharSequence)this.salt, this.iv, AesBytesEncryptor.CipherAlgorithm.GCM);
            byte[] enc = encryptor.encrypt(json.getBytes(StandardCharsets.UTF_8));
            Files.write(dataPath, enc, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Error saving encrypted secrets to [%s]".formatted(dataPath), e);
        }
    }
}

