/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.central.biz;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Map;
import net.solarnetwork.central.biz.NetworkIdentificationBiz;
import net.solarnetwork.domain.BasicNetworkIdentity;
import net.solarnetwork.domain.NetworkIdentity;
import net.solarnetwork.util.ByteUtils;
import net.solarnetwork.util.ObjectUtils;
import org.springframework.core.io.Resource;
import org.springframework.util.FileCopyUtils;

public class BasicNetworkIdentificationBiz
implements NetworkIdentificationBiz {
    private final String networkIdentityKey;
    private final Resource termsOfService;
    private final String host;
    private final Integer port;
    private final boolean forceTLS;
    private final Map<String, String> networkServiceUrls;

    public BasicNetworkIdentificationBiz(String networkIdentityKey, Resource termsOfService, String host, Integer port, boolean forceTLS, Map<String, String> networkServiceUrls) {
        this.networkIdentityKey = (String)ObjectUtils.requireNonNullArgument((Object)networkIdentityKey, (String)"networkIdentityKey");
        this.termsOfService = (Resource)ObjectUtils.requireNonNullArgument((Object)termsOfService, (String)"termsOfService");
        this.host = (String)ObjectUtils.requireNonNullArgument((Object)host, (String)"host");
        this.port = (Integer)ObjectUtils.requireNonNullArgument((Object)port, (String)"port");
        this.forceTLS = (Boolean)ObjectUtils.requireNonNullArgument((Object)forceTLS, (String)"forceTLS");
        this.networkServiceUrls = (Map)ObjectUtils.requireNonNullArgument(networkServiceUrls, (String)"networkServiceUrls");
    }

    @Override
    public NetworkIdentity getNetworkIdentity() {
        Object tos = "";
        try {
            tos = FileCopyUtils.copyToString((Reader)new BufferedReader(new InputStreamReader(this.termsOfService.getInputStream(), ByteUtils.UTF8)));
        }
        catch (IOException e) {
            tos = "Error, missing TOS resource: " + e.getMessage();
        }
        BasicNetworkIdentity ident = new BasicNetworkIdentity(this.networkIdentityKey, (String)tos, this.host, this.port, Boolean.valueOf(this.forceTLS));
        ident.setNetworkServiceURLs(this.networkServiceUrls);
        return ident;
    }
}

