/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.central.biz;

import net.solarnetwork.central.biz.AppWarmUpTask;
import net.solarnetwork.service.ServiceLifecycleObserver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppWarmUpManager
implements ServiceLifecycleObserver {
    private static final Logger log = LoggerFactory.getLogger(AppWarmUpManager.class);
    private final Iterable<AppWarmUpTask> warmUpTasks;

    public AppWarmUpManager(Iterable<AppWarmUpTask> warmUpTasks) {
        this.warmUpTasks = warmUpTasks;
    }

    public void serviceDidShutdown() {
    }

    public void serviceDidStartup() {
        if (this.warmUpTasks == null) {
            return;
        }
        log.info("Performing app warm-up tasks...");
        for (AppWarmUpTask task : this.warmUpTasks) {
            try {
                log.debug("Executing app warm-up task [{}]...", (Object)task);
                task.warmUp();
            }
            catch (Exception e) {
                log.error("App warm-up task [{}] threw exception: {}", new Object[]{task, e.getMessage(), e});
            }
        }
        log.info("App warm-up tasks complete.");
    }
}

