/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.central.aop;

import net.solarnetwork.central.dao.SolarNodeOwnershipDao;
import net.solarnetwork.central.domain.UserMetadataFilter;
import net.solarnetwork.central.security.AuthorizationException;
import net.solarnetwork.central.security.AuthorizationSupport;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class UserMetadataSecurityAspect
extends AuthorizationSupport {
    public UserMetadataSecurityAspect(SolarNodeOwnershipDao nodeOwnershipDao) {
        super(nodeOwnershipDao);
    }

    @Pointcut(value="execution(* net.solarnetwork.central.biz.UserMetadataBiz.addGeneralNode*(..)) && args(userId,..)")
    public void modifyMetadata(Long userId) {
    }

    @Pointcut(value="execution(* net.solarnetwork.central.biz.UserMetadataBiz.findUserMetadata(..)) && args(filter,..)")
    public void listMetadata(UserMetadataFilter filter) {
    }

    @Before(value="modifyMetadata(userId)")
    public void modifyMetadataCheck(Long userId) {
        this.requireUserWriteAccess(userId);
    }

    @Before(value="listMetadata(filter)")
    public void listMetadataCheck(UserMetadataFilter filter) {
        if (filter == null || !filter.hasUserCriteria()) {
            throw new AuthorizationException(AuthorizationException.Reason.ACCESS_DENIED, null);
        }
        Long[] ids = filter.getUserIds();
        if (ids != null) {
            for (Long userId : ids) {
                this.requireUserReadAccess(userId);
            }
        }
    }
}

