/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.central;

import java.util.UUID;
import net.solarnetwork.util.ObjectUtils;

public class ApplicationMetadata {
    private final String name;
    private final String version;
    private final String instanceId;

    public ApplicationMetadata(String name, String version, String instanceId) {
        this.name = (String)ObjectUtils.requireNonNullArgument((Object)name, (String)"name");
        this.version = version != null ? version : "";
        this.instanceId = instanceId != null && !instanceId.isBlank() ? instanceId : UUID.randomUUID().toString();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ApplicationMetadata{");
        if (this.name != null && !this.name.isBlank()) {
            builder.append("name=").append(this.name).append(", ");
        }
        if (this.version != null && !this.version.isBlank()) {
            builder.append("version=").append(this.version).append(", ");
        }
        if (this.instanceId != null && !this.instanceId.isBlank()) {
            builder.append("instanceId=").append(this.instanceId);
        }
        builder.append("}");
        return builder.toString();
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public String getInstanceId() {
        return this.instanceId;
    }
}

