/* ==================================================================
 * NodeUserDetailsService.java - Mar 17, 2011 2:27:24 PM
 * 
 * Copyright 2007-2011 SolarNetwork.net Dev Team
 * 
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of 
 * the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, 
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License 
 * along with this program; if not, write to the Free Software 
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 
 * 02111-1307 USA
 * ==================================================================
 */

package net.solarnetwork.central.security;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.springframework.dao.DataAccessException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

/**
 * Implementation of {@link UserDetailsService} for X.509 authenticated nodes.
 * 
 * @author matt
 * @version 1.0
 */
public class NodeUserDetailsService implements UserDetailsService {

	/** The default authorities to grant. */
	protected static final Collection<GrantedAuthority> AUTHORITIES = getAuthorities();

	private static Collection<GrantedAuthority> getAuthorities() {
		Collection<GrantedAuthority> authorities = new ArrayList<GrantedAuthority>(1);
		authorities.add(new SimpleGrantedAuthority("ROLE_NODE"));
		return Collections.unmodifiableCollection(authorities);
	}

	@Override
	public UserDetails loadUserByUsername(String username)
			throws UsernameNotFoundException, DataAccessException {
		try {
			Long id = Long.valueOf(username);
			return new AuthenticatedNode(id, AUTHORITIES, false);
		} catch ( NumberFormatException e ) {
			// not a node
			throw new UsernameNotFoundException("Username [" + username + "] is not a valid ndoe ID.");
		}
	}

}
