/* ==================================================================
 * LocationRequestStatus.java - 19/05/2022 1:40:59 pm
 * 
 * Copyright 2022 SolarNetwork.net Dev Team
 * 
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of 
 * the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, 
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License 
 * along with this program; if not, write to the Free Software 
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 
 * 02111-1307 USA
 * ==================================================================
 */

package net.solarnetwork.central.domain;

import net.solarnetwork.domain.CodedValue;

/**
 * Location request status enumeration.
 * 
 * @author matt
 * @version 1.0
 * @since 1.3
 */
public enum LocationRequestStatus implements CodedValue {

	/** The request has been submitted and received. */
	Submitted('s'),

	/** The request has been rejected. */
	Rejected('r'),

	/** The request was found to be a duplicate for an existing location. */
	Duplicate('d'),

	/** The location has been created. */
	Created('c'),

	;

	private final int code;

	private LocationRequestStatus(char code) {
		this.code = code;
	}

	@Override
	public int getCode() {
		return code;
	}

}
