/* ==================================================================
 * NetworkAssociationDao.java - Nov 29, 2012 10:43:43 AM
 * 
 * Copyright 2007-2012 SolarNetwork.net Dev Team
 * 
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of 
 * the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, 
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License 
 * along with this program; if not, write to the Free Software 
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 
 * 02111-1307 USA
 * ==================================================================
 */

package net.solarnetwork.central.dao;

import net.solarnetwork.domain.NetworkAssociation;

/**
 * DAO API for network association support.
 * 
 * @author matt
 * @version 1.0
 */
public interface NetworkAssociationDao {

	/**
	 * Get a network association for a confirmation code.
	 * 
	 * <p>
	 * The confirmation code would have been generated by SolarNet and passed to
	 * the user to confirm on their node.
	 * </p>
	 * 
	 * @param username
	 *        the username used when generating the confirmation code
	 * @param confirmationCode
	 *        the confirmation code
	 * @return the association, or <em>null</em> if none available
	 */
	NetworkAssociation getNetworkAssociationForConfirmationKey(String username, String confirmationCode);

}
