/* ==================================================================
 * UserEventDao.java - 1/08/2022 2:27:40 pm
 * 
 * Copyright 2022 SolarNetwork.net Dev Team
 * 
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of 
 * the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, 
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License 
 * along with this program; if not, write to the Free Software 
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 
 * 02111-1307 USA
 * ==================================================================
 */

package net.solarnetwork.central.common.dao;

import java.io.IOException;
import net.solarnetwork.central.domain.UserEvent;
import net.solarnetwork.central.domain.UserUuidPK;
import net.solarnetwork.central.support.FilteredResultsProcessor;
import net.solarnetwork.dao.FilterableDao;

/**
 * DAO API user events.
 * 
 * @author matt
 * @version 1.1
 */
public interface UserEventDao
		extends UserEventAppenderDao, FilterableDao<UserEvent, UserUuidPK, UserEventFilter> {

	/**
	 * API for querying for a filtered stream of {@link UserEvent} entities.
	 * 
	 * @param filter
	 *        the filter
	 * @param processor
	 *        the stream processor
	 * @throws IOException
	 *         if any IO error occurs
	 * @since 1.1
	 */
	void findFilteredStream(UserEventFilter filter, FilteredResultsProcessor<UserEvent> processor)
			throws IOException;

}
