/* ==================================================================
 * NodeCriteria.java - 23/10/2020 9:16:44 pm
 * 
 * Copyright 2020 SolarNetwork.net Dev Team
 * 
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of 
 * the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, 
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License 
 * along with this program; if not, write to the Free Software 
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 
 * 02111-1307 USA
 * ==================================================================
 */

package net.solarnetwork.central.common.dao;

/**
 * Search criteria for node related data.
 * 
 * @author matt
 * @version 1.1
 * @since 2.8
 */
public interface NodeCriteria {

	/**
	 * Get the first node ID.
	 * 
	 * <p>
	 * This returns the first available node ID from the {@link #getNodeIds()}
	 * array, or {@literal null} if not available.
	 * </p>
	 * 
	 * @return the node ID, or {@literal null} if not available
	 */
	Long getNodeId();

	/**
	 * Get an array of node IDs.
	 * 
	 * @return array of node IDs (may be {@literal null})
	 */
	Long[] getNodeIds();

	/**
	 * Test if this filter has any node criteria.
	 * 
	 * @return {@literal true} if the node ID is non-null
	 * @since 1.1
	 */
	default boolean hasNodeCriteria() {
		return getNodeId() != null;
	}

}
